/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldProperties;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.Sorting;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.search.function.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldType
extends FieldProperties {
    public static final Logger log = LoggerFactory.getLogger(FieldType.class);
    public static final String POLY_FIELD_SEPARATOR = "___";
    protected String typeName;
    protected Map<String, String> args;
    protected int trueProperties;
    protected int falseProperties;
    int properties;
    protected Analyzer analyzer;
    protected Analyzer queryAnalyzer;

    public FieldType() {
        this.queryAnalyzer = this.analyzer = new DefaultAnalyzer(256);
    }

    public boolean isTokenized() {
        return (this.properties & 2) != 0;
    }

    public boolean isMultiValued() {
        return (this.properties & 0x200) != 0;
    }

    protected boolean hasProperty(int p) {
        return (this.properties & p) != 0;
    }

    public boolean isPolyField() {
        return false;
    }

    public boolean multiValuedFieldCache() {
        return this.isTokenized();
    }

    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    protected String getArg(String n, Map<String, String> args) {
        String s = args.remove(n);
        if (s == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing parameter '" + n + "' for FieldType=" + this.typeName + args);
        }
        return s;
    }

    void setArgs(IndexSchema schema, Map<String, String> args) {
        this.properties = 5;
        float schemaVersion = schema.getVersion();
        if (schemaVersion < 1.1f) {
            this.properties |= 0x200;
        }
        if (schemaVersion > 1.1f) {
            this.properties |= 0x20;
        }
        if ((double)schemaVersion < 1.3) {
            args.remove("compressThreshold");
        }
        this.args = args;
        HashMap<String, String> initArgs = new HashMap<String, String>(args);
        this.trueProperties = FieldProperties.parseProperties(initArgs, true);
        this.falseProperties = FieldProperties.parseProperties(initArgs, false);
        this.properties &= ~this.falseProperties;
        this.properties |= this.trueProperties;
        for (String prop : FieldProperties.propertyNames) {
            initArgs.remove(prop);
        }
        this.init(schema, initArgs);
        String positionInc = (String)initArgs.get("positionIncrementGap");
        if (positionInc != null) {
            Analyzer analyzer = this.getAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            analyzer = this.getQueryAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            initArgs.remove("positionIncrementGap");
        }
        if (initArgs.size() > 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid arguments:" + initArgs);
        }
    }

    protected void restrictProps(int props) {
        if ((this.properties & props) != 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid properties:" + FieldType.propertiesToString(this.properties & props));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return this.typeName + "{class=" + this.getClass().getName() + (this.analyzer != null ? ",analyzer=" + this.analyzer.getClass().getName() : "") + ",args=" + this.args + "}";
    }

    public Fieldable createField(SchemaField field, String externalVal, float boost) {
        String val;
        if (!field.indexed() && !field.stored()) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        try {
            val = this.toInternal(externalVal);
        }
        catch (RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while creating field '" + field + "' from value '" + externalVal + "'", (Throwable)e, false);
        }
        if (val == null) {
            return null;
        }
        return this.createField(field.getName(), val, this.getFieldStore(field, val), this.getFieldIndex(field, val), this.getFieldTermVec(field, val), field.omitNorms(), this.getIndexOptions(field, val), boost);
    }

    protected Fieldable createField(String name, String val, Field.Store storage, Field.Index index, Field.TermVector vec, boolean omitNorms, FieldInfo.IndexOptions options, float boost) {
        Field f = new Field(name, val, storage, index, vec);
        if (index.isIndexed()) {
            f.setOmitNorms(omitNorms);
            f.setIndexOptions(options);
            f.setBoost(boost);
        }
        return f;
    }

    public Fieldable[] createFields(SchemaField field, String externalVal, float boost) {
        Fieldable[] fieldableArray;
        Fieldable f = this.createField(field, externalVal, boost);
        if (f == null) {
            fieldableArray = new Fieldable[]{};
        } else {
            Fieldable[] fieldableArray2 = new Fieldable[1];
            fieldableArray = fieldableArray2;
            fieldableArray2[0] = f;
        }
        return fieldableArray;
    }

    protected Field.TermVector getFieldTermVec(SchemaField field, String internalVal) {
        Field.TermVector ftv = Field.TermVector.NO;
        if (field.storeTermPositions() && field.storeTermOffsets()) {
            ftv = Field.TermVector.WITH_POSITIONS_OFFSETS;
        } else if (field.storeTermPositions()) {
            ftv = Field.TermVector.WITH_POSITIONS;
        } else if (field.storeTermOffsets()) {
            ftv = Field.TermVector.WITH_OFFSETS;
        } else if (field.storeTermVector()) {
            ftv = Field.TermVector.YES;
        }
        return ftv;
    }

    protected Field.Store getFieldStore(SchemaField field, String internalVal) {
        return field.stored() ? Field.Store.YES : Field.Store.NO;
    }

    protected Field.Index getFieldIndex(SchemaField field, String internalVal) {
        return field.indexed() ? (this.isTokenized() ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED) : Field.Index.NO;
    }

    protected FieldInfo.IndexOptions getIndexOptions(SchemaField field, String internalVal) {
        FieldInfo.IndexOptions options = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        if (field.omitTermFreqAndPositions()) {
            options = FieldInfo.IndexOptions.DOCS_ONLY;
        } else if (field.omitPositions()) {
            options = FieldInfo.IndexOptions.DOCS_AND_FREQS;
        }
        return options;
    }

    public String toInternal(String val) {
        return val;
    }

    public String toExternal(Fieldable f) {
        return f.stringValue();
    }

    public Object toObject(Fieldable f) {
        return this.toExternal(f);
    }

    public String indexedToReadable(String indexedForm) {
        return indexedForm;
    }

    public String storedToReadable(Fieldable f) {
        return this.toExternal(f);
    }

    public String storedToIndexed(Fieldable f) {
        return f.stringValue();
    }

    public String readableToIndexed(String val) {
        return this.toInternal(val);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
        SolrException.logOnce((Logger)log, null, (Throwable)e);
        throw e;
    }

    public void setQueryAnalyzer(Analyzer analyzer) {
        SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
        SolrException.logOnce((Logger)log, null, (Throwable)e);
        throw e;
    }

    public abstract void write(XMLWriter var1, String var2, Fieldable var3) throws IOException;

    public abstract void write(TextResponseWriter var1, String var2, Fieldable var3) throws IOException;

    public abstract SortField getSortField(SchemaField var1, boolean var2);

    protected SortField getStringSort(SchemaField field, boolean reverse) {
        field.checkSortability();
        return Sorting.getStringSortField(field.name, reverse, field.sortMissingLast(), field.sortMissingFirst());
    }

    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new OrdFieldSource(field.name);
    }

    @Deprecated
    public ValueSource getValueSource(SchemaField field) {
        return this.getValueSource(field, null);
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        return new TermRangeQuery(field.getName(), part1 == null ? null : this.toInternal(part1), part2 == null ? null : this.toInternal(part2), minInclusive, maxInclusive);
    }

    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return new TermQuery(new Term(field.getName(), this.toInternal(externalVal)));
    }

    protected final class DefaultAnalyzer
    extends SolrAnalyzer {
        final int maxChars;

        DefaultAnalyzer(int maxChars) {
            this.maxChars = maxChars;
        }

        public SolrAnalyzer.TokenStreamInfo getStream(String fieldName, Reader reader) {
            Tokenizer ts = new Tokenizer(reader){
                final char[] cbuf;
                final CharTermAttribute termAtt;
                final OffsetAttribute offsetAtt;
                {
                    this.cbuf = new char[DefaultAnalyzer.this.maxChars];
                    this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                    this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
                }

                public boolean incrementToken() throws IOException {
                    this.clearAttributes();
                    int n = this.input.read(this.cbuf, 0, DefaultAnalyzer.this.maxChars);
                    if (n <= 0) {
                        return false;
                    }
                    String s = FieldType.this.toInternal(new String(this.cbuf, 0, n));
                    this.termAtt.setEmpty().append(s);
                    this.offsetAtt.setOffset(this.correctOffset(0), this.correctOffset(n));
                    return true;
                }
            };
            return new SolrAnalyzer.TokenStreamInfo(ts, (TokenStream)ts);
        }
    }
}

