/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.DateStatsValues;
import org.apache.solr.handler.component.NumericStatsValues;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StringStatsValues;
import org.apache.solr.schema.ByteField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.DoubleField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatField;
import org.apache.solr.schema.IntField;
import org.apache.solr.schema.LongField;
import org.apache.solr.schema.ShortField;
import org.apache.solr.schema.SortableDoubleField;
import org.apache.solr.schema.SortableFloatField;
import org.apache.solr.schema.SortableIntField;
import org.apache.solr.schema.SortableLongField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieField;

public class StatsValuesFactory {
    public static StatsValues createStatsValues(FieldType fieldType) {
        if (DoubleField.class.isInstance(fieldType) || IntField.class.isInstance(fieldType) || LongField.class.isInstance(fieldType) || ShortField.class.isInstance(fieldType) || FloatField.class.isInstance(fieldType) || ByteField.class.isInstance(fieldType) || TrieField.class.isInstance(fieldType) || SortableDoubleField.class.isInstance(fieldType) || SortableIntField.class.isInstance(fieldType) || SortableLongField.class.isInstance(fieldType) || SortableFloatField.class.isInstance(fieldType)) {
            return new NumericStatsValues(fieldType);
        }
        if (DateField.class.isInstance(fieldType)) {
            return new DateStatsValues(fieldType);
        }
        if (StrField.class.isInstance(fieldType)) {
            return new StringStatsValues(fieldType);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field type " + fieldType + " is not currently supported");
    }
}

