/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.Arrays;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.function.CharShortProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.AbstractCharShortMap;
import org.apache.mahout.math.map.HashFunctions;

public class OpenCharShortHashMap
extends AbstractCharShortMap {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final char NO_KEY_VALUE = '\u0000';
    protected char[] table;
    protected short[] values;
    protected byte[] state;
    protected int freeEntries;

    public OpenCharShortHashMap() {
        this(277);
    }

    public OpenCharShortHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenCharShortHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public void clear() {
        Arrays.fill(this.state, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenCharShortHashMap copy = (OpenCharShortHashMap)super.clone();
        copy.table = (char[])copy.table.clone();
        copy.values = (short[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    public boolean containsKey(char key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(short value) {
        return this.indexOfValue(value) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public boolean forEachKey(CharProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(CharShortProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public short get(char key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return 0;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(char key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] == 1 && this.table[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 2) {
            int j = i;
            while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.state[i] == 0) {
                i = j;
            }
        }
        if (this.state[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(char key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(short value) {
        short[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void keys(CharArrayList list) {
        list.setSize(this.distinct);
        char[] elements = list.elements();
        int j = 0;
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.table[i];
        }
    }

    public void pairsMatching(CharShortProcedure condition, CharArrayList keyList, ShortArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    public boolean put(char key, short value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    public short adjustOrPutValue(char key, short newValue, short incrValue) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            int n = i = -i - 1;
            this.values[n] = (short)(this.values[n] + incrValue);
            return this.values[i];
        }
        this.put(key, newValue);
        return newValue;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        char[] oldTable = this.table;
        short[] oldValues = this.values;
        byte[] oldState = this.state;
        this.table = new char[newCapacity];
        this.values = new short[newCapacity];
        this.state = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            char element = oldTable[i];
            int index = this.indexOfInsertion(element);
            this.table[index] = element;
            this.values[index] = oldValues[i];
            this.state[index] = 1;
        }
    }

    public boolean removeKey(char key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new char[capacity];
        this.values = new short[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public void values(ShortArrayList list) {
        list.setSize(this.distinct);
        short[] elements = list.elements();
        int j = 0;
        int i = this.state.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.values[i];
        }
    }

    protected void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }
}

