/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.rtf.TextExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTFParser
extends AbstractParser {
    private static final long serialVersionUID = -4165069489372320313L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"rtf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TaggedInputStream tagged = new TaggedInputStream(stream);
        try {
            TextExtractor ert = new TextExtractor(new XHTMLContentHandler(handler, metadata), metadata);
            ert.extract(stream);
            metadata.add("Content-Type", "application/rtf");
        }
        catch (IOException e) {
            tagged.throwIfCauseOf((Exception)e);
            throw new TikaException("Error parsing an RTF document", (Throwable)e);
        }
    }
}

