/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Arrays;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.Vector;

public class DenseMatrix
extends AbstractMatrix {
    protected double[][] values;

    public DenseMatrix() {
    }

    protected int columnSize() {
        return this.values[0].length;
    }

    protected int rowSize() {
        return this.values.length;
    }

    public DenseMatrix(double[][] values) {
        this.values = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = (double[])values[i].clone();
        }
    }

    public DenseMatrix(int rows, int columns) {
        this.values = new double[rows][columns];
    }

    public int[] size() {
        int[] result = new int[]{this.rowSize(), this.columnSize()};
        return result;
    }

    public Matrix clone() {
        DenseMatrix clone = (DenseMatrix)super.clone();
        clone.values = new double[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            clone.values[i] = (double[])this.values[i].clone();
        }
        return clone;
    }

    public double getQuick(int row, int column) {
        return this.values[row][column];
    }

    public Matrix like() {
        return this.like(this.rowSize(), this.columnSize());
    }

    public Matrix like(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    public void setQuick(int row, int column, double value) {
        this.values[row][column] = value;
    }

    public int[] getNumNondefaultElements() {
        return this.size();
    }

    public Matrix viewPart(int[] offset, int[] size) {
        if (size[0] > this.rowSize() || size[1] > this.columnSize()) {
            throw new CardinalityException();
        }
        if (offset[0] < 0 || offset[0] + size[0] > this.rowSize() || offset[1] < 0 || offset[1] + size[1] > this.columnSize()) {
            throw new IndexException();
        }
        return new MatrixView(this, offset, size);
    }

    public Matrix assign(double value) {
        for (int row = 0; row < this.rowSize(); ++row) {
            Arrays.fill(this.values[row], value);
        }
        return this;
    }

    public Matrix assignColumn(int column, Vector other) {
        if (other.size() != this.rowSize() || column >= this.columnSize()) {
            throw new CardinalityException();
        }
        for (int row = 0; row < this.rowSize(); ++row) {
            this.values[row][column] = other.getQuick(row);
        }
        return this;
    }

    public Matrix assignRow(int row, Vector other) {
        if (row >= this.rowSize() || other.size() != this.columnSize()) {
            throw new CardinalityException();
        }
        for (int col = 0; col < this.columnSize(); ++col) {
            this.values[row][col] = other.getQuick(col);
        }
        return this;
    }

    public Vector getColumn(int column) {
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException();
        }
        return new AbstractMatrix.TransposeViewVector(this, column);
    }

    public Vector getRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException();
        }
        return new DenseVector(this.values[row], true);
    }
}

