/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.AbstractClassNameFilter;

class IncludeClassNameFilter
extends AbstractClassNameFilter {
    IncludeClassNameFilter(String ... patterns) {
        super(patterns);
    }

    @Override
    public FilterResult apply(String className) {
        return this.findMatchingPattern(className).map(pattern -> FilterResult.included(this.formatInclusionReason(className, (Pattern)pattern))).orElseGet(() -> FilterResult.excluded(this.formatExclusionReason(className)));
    }

    private String formatExclusionReason(String className) {
        return String.format("Class name [%s] does not match any included pattern: %s", className, this.patternDescription);
    }

    private String formatInclusionReason(String className, Pattern pattern) {
        return String.format("Class name [%s] matches included pattern: '%s'", className, pattern);
    }

    @Override
    public Predicate<String> toPredicate() {
        return className -> this.findMatchingPattern((String)className).isPresent();
    }

    public String toString() {
        return "Includes class names that match regular expression " + this.patternDescription;
    }
}

