// ===========================================================================
// File: "aidaDefinitions.h"
//                        Created: 2010-09-15 12:08:14
//              Last modification: 2014-06-24 15:50:48
// Author: Bernard Desgraupes
// e-mail: <bdesgraupes@users.sourceforge.net>
// Copyright (c) 2010-2014 Bernard Desgraupes
// All rights reserved.
// ===========================================================================

#ifndef AIDA_DEFINITIONS_H
#define AIDA_DEFINITIONS_H

#define AIDA_CONTEXTS_MAX 256
#define AIDA_IFCONDS_MAX 256


// Uncomment some of the following #defines to print debug info:
// #define AIDA_DEBUG_CONTEXT
// #define AIDA_DEBUG_DSTRING
// #define AIDA_DEBUG_IFELSE
// #define AIDA_DEBUG_PRINTF
// #define AIDA_DEBUG_LOC



// Structs
// -------

typedef struct aida_parse_t
{
	int				num;		// TEMPORARY to help debugging and identifying scanners
	void *			scan;		// pointer to the lexer
	void *			data;		// pointer to the data being parsed
	int				to;			// where does it write to
	union {
		FILE *			fptr;
		Tcl_DString *	dstr;
		Tcl_Obj *		objp;
	} out;		 				// pointer to output (depending on 'to')
	int				start;		// start condition
	Tcl_Encoding	enc;		// output encoding
	int				sublevel;	// count of opened list items
	int				ctxCount;
	int				contexts[AIDA_CONTEXTS_MAX];	// stack of states
} aida_parse_t;


typedef struct aida_frag_t aida_frag_t;
typedef struct aida_file_t aida_file_t;
typedef struct aida_split_t aida_split_t;
typedef struct aida_incl_t aida_incl_t;
typedef struct aida_enc_t aida_enc_t;

struct aida_file_t
{
	bool			closed;		// is the file closed?
	FILE *			desc;		// file descriptor
	char *			name;		// file name
};

struct aida_split_t
{
	int				index;		// index of split file
	char *			name;		// file name
};

struct aida_frag_t
{
	int				num;		// used only by debugging functions
	int				kind;		// kind of file
	union {
		aida_file_t		file;
		aida_split_t	split;
		Tcl_Obj *		proc;
	} u;		 				// fragment data (depending on kind)
	aida_frag_t *	next;
};

struct aida_incl_t
{
	aida_incl_t *	caller;		// the calling input struct
	Tcl_Obj *		base;		// dirname 
	char *			name;
	FILE *			fptr;
	bool			std;		// is it stdin?
	bool			tmp;		// is it a temp file?
};

struct aida_enc_t {
	Tcl_Encoding	ienc;	// input encoding
	Tcl_Encoding	oenc;	// output encoding
	Tcl_Encoding	tenc;	// transcoding
	char *			inam;	// name of ienc
	char *			onam;	// name of oenc
	bool			utf8;	// is the input parsed as UTF-8?
	bool			sing;	// is the input encoding single-byte?
};



// Enumerations
// ------------

enum {
	kind_file,
	kind_proc,
	kind_split
};

enum {
	AIDA_CMD_CONVERT,	AIDA_CMD_HELP,	AIDA_CMD_INFO,	AIDA_CMD_SPLIT
};

enum {
	AIDA_INFO_ATTRIBUTES,	AIDA_INFO_CONFIGURATION,	AIDA_INFO_ENCODINGS,	AIDA_INFO_EXTENSIONS,
	AIDA_INFO_FROM,      	AIDA_INFO_LIBRARY,      	AIDA_INFO_LICENSE,  	AIDA_INFO_MAPPING,	
	AIDA_INFO_PARAMETERS,	AIDA_INFO_PATH,         	AIDA_INFO_SYSENC,   	AIDA_INFO_TARGETS,	
	AIDA_INFO_TEMP,      	AIDA_INFO_TO,           	AIDA_INFO_VERSION   
};

enum {
	GLOBAL_OPTION_D,	GLOBAL_OPTION_L,	GLOBAL_OPTION_Q,	GLOBAL_OPTION_TL,
	GLOBAL_OPTION_TP,	GLOBAL_OPTION_X
};

enum {
	CONVERT_OPTION_COLLAPSE,	CONVERT_OPTION_EVAL,  	CONVERT_OPTION_FROM,	CONVERT_OPTION_OUTPUT,
	CONVERT_OPTION_PREFIX,  	CONVERT_OPTION_TARGET,	CONVERT_OPTION_TO,  	CONVERT_OPTION_DASH   
};

enum {
	SPLIT_OPTION_COLLAPSE,	SPLIT_OPTION_EVAL,  	SPLIT_OPTION_FROM,  	SPLIT_OPTION_LEVEL,
	SPLIT_OPTION_OUTPUT,  	SPLIT_OPTION_PREFIX,	SPLIT_OPTION_TARGET,	SPLIT_OPTION_TO,   
	SPLIT_OPTION_DASH
};

enum {
	AIDA_HELP_HEADER,	AIDA_HELP_SYNTAX
};


enum {
	to_fptr,
	to_dstr,
	to_objp
};



#define AIDA_CHECK(Result, Label, Msg)		\
  if (Result != TCL_OK)						\
    {										\
		if (strlen(Msg)) {					\
		    aida_print_err(Msg);			\
		}									\
      goto Label;							\
    }



#define AIDAMAP(c) (gMapChars && gMap[(unsigned char)*c] != NULL)? Tcl_GetString(gMap[(unsigned char)*c]):c



#endif  // AIDA_DEFINITIONS_H
