# ===========================================================================
# File: "aidaMode.tcl"
#                        Created: 2010-09-25 12:05:28
#              Last modification: 2011-02-09 19:06:33
# Author: Bernard Desgraupes
# Description: editing facility for the Aida marking scheme.
# Aida is a markup scheme for documentation files using a generic syntax 
# which can be converted to various formats (html, pdf, text, man, xml etc.)
# 
# (c) Copyright: Bernard Desgraupes, 2010-2011
#         All rights reserved.
# This software is free software. 
# See licensing terms in the Aida Help file.
# ===========================================================================


alpha::mode Aida 1.0 source {*.aida *.ainc *.ainp } {
	aidaMenu
} {
	addMenu aidaMenu "Aida" Aida
} maintainer {
	"Bernard Desgraupes" <bdesgraupes@users.sourceforge.net> <http://perso.orange.fr/bdesgraupes/alpha.html> 
} help {file "AidaHelp"}


# Preferences
# -----------
newPref f autoMark {0} Aida
newPref v prefixString {!! } Aida 
newPref v wordBreak {[_\w]+} Aida
newPref f wordWrap {0} Aida
# should a converted file be saved in the same folder as the source 
# file or should the user be prompted with a save dialog?
newPref f saveInSameFolder {0} Aida
# this flag should normally be on. If an error occurs during 
# conversion, the original aida file will be restored. Uncheck only if 
# you need to do some debugging. 
newPref f revertOriginalOnError {1} Aida
# when splitting at input files, should Aida reproduce the same hierarchy
# of files or flatten all the output files in a single folder? This does
# not apply when splitting at section marks (s1-s5).
newPref f preserveInputStruct {1} Aida
# should the original aida file be reopened after a conversion?
newPref f reopenSourceAfterConversion {0} Aida
# color for comments
newPref v commentColor red Aida stringColorProc
# color for strings
newPref v stringColor green Aida stringColorProc
# color for Aida tags
newPref v showtagsColor blue Aida stringColorProc
# color for section titles in Text format
newPref v sectionColor blue Aida stringColorProc
# which level of subsections should be listed in the table of 
# contents (0 to 5)?
newPref v tocDepth 3 Aida
# which level of subsections should be numbered? Values between 
# 0 and 5, 0 means no numbering.
newPref v numberingDepth 3 Aida 


namespace eval Aida {
	variable debug 0
	variable currTrgtIndex 0
}

# Initialisation
# --------------
set Aida::commentCharacters(General) {!!}
set Aida::commentCharacters(Paragraph)  [list "!!!! " "!!!!" "!! "]
set Aida::commentCharacters(Box) [list "!!" 2 "!!" 2 "!" 3]

	set aida_params(tagscolor) $AidamodeVars(showtagsColor)


proc aidaMode.tcl {} {}
proc aidaMenu {} {}


# Syntax coloring
# ---------------
set aida_params(tags) { ((a ((b ((dl ((e ((else ((hr)) ((i ((if ((img
((index)) ((include ((input ((li ((lk ((lt ((nl)) ((ol ((q ((rf ((split))
((s1 ((s2 ((s3 ((s4 ((s5 ((s6 ((table ((toc)) ((tr ((u ((ul ((v ((x ((y 
a)) b)) dl)) e)) i)) if)) img)) li)) lk)) lt)) ol)) q)) rf)) 
s1)) s2)) s3)) s4)) s5)) s6)) table)) tr)) u)) ul)) v)) x)) y)) ((| |))
}

regModeKeywords -e {!} -b {/*} {*/} -c $AidamodeVars(commentColor) \
  -s $AidamodeVars(stringColor) Aida {}


proc Aida::colorizeAida {{pref ""}} {
	global AidamodeVars aida_params colorInds
	regModeKeywords -a -k $aida_params(tagscolor) Aida $aida_params(tags)
	regModeKeywords -a -k red -m : Aida ""
}

Aida::colorizeAida

# Completions
# -----------
set completions(Aida) {completion::cmd completion::electric}
set Aidacmds ""

set Aidaelectrics(if) "kill0((if \r\r((else\r\rif))"
set Aidaelectrics(img) "kill0((img \r img))"
set Aidaelectrics(lk) "kill0((lk \[\]  lk))"
set Aidaelectrics(rf) "kill0((rf \[\]  rf))"


# ------------
# File marking
# ------------

proc Aida::MarkFile {} {
	global AidamodeVars aida_params 
	if {[info exists inds]} {
		unset inds
	}
	if {![catch {search -all -s -f 1 -r 1 \
	  "^\\\(\\\(s(\[1-$AidamodeVars(tocDepth)\])\\\s+" [minPos]} res]} {
		foreach {start end} $res {
			catch {
				set pname [getText $end [pos::math [nextLineStart $start] - 1]]
				set sec [getText [pos::math $start + 3] [pos::math $start + 4]]
				regsub " s${sec}\\)\\)" $pname "" pname
				set word ""
				for {set i 1} {$i<$sec} {incr i} {
					append word "   "
				}
				append word $pname
				if {$pname!=""} {
					set inds($word) [lineStart [pos::math $start - 1]]
				}
			}
			
		}
	}
	if {[info exists inds]} {
		foreach f [lsort -dictionary [array names inds]] {
			set res $inds($f)
			setNamedMark " $f" [nextLineStart $res] $res $res
		}
	}
	orderMarks
}



# Key bindings
# ------------
# Most of the bindings are created during menu building via the
# [menu::addItemWithBinding] proc.
# All bindings in Aida mode are prefixed with ctrl-a.
binding create -tag Aida {z 'a'} prefixChar


# ---------------------------------------------------------------------
# Now load the files containing the menu definitions
# ---------------------------------------------------------------------
if {![alpha::tryToLoad "Initializing Aida mode" \
  aidaMenus.tcl {Loading Aida menus} \
  ]} {
	alertnote "Error: the Aida menu did not properly load."
}

status::msg "Aida mode initialization complete."

