# ===========================================================================
# File: "aclocal.m4"
#                        Created: 2010-08-10 19:31:05
#              Last modification: 2013-12-13 12:38:47
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# (c) Copyright: Bernard Desgraupes 2010-2013
# This file is part of the Aida project.
# ===========================================================================

builtin(include,version.m4)

define(`AIDA_BUILD_PRINT_LINE', `aida_print_out("%s\n", "$*");')


# ---------------
# Check for flex
# ---------------
AC_DEFUN(AIDA_PROG_FLEX, [
  AC_PROG_LEX
  if test -z "$LEX" ; then
      AC_MSG_ERROR([flex missing: this is fatal])  	
  fi 
])


# ---------------
# Check for bison
# ---------------
AN_MAKEVAR([BISON],  [AIDA_PROG_BISON])
AN_MAKEVAR([YACC],   [AIDA_PROG_BISON])
AN_MAKEVAR([YFLAGS], [AIDA_PROG_BISON])
AN_PROGRAM([yacc],   [AIDA_PROG_BISON])
AN_PROGRAM([byacc],  [AIDA_PROG_BISON])
AN_PROGRAM([bison],  [AIDA_PROG_BISON])
AC_DEFUN([AIDA_PROG_BISON],
[AC_CHECK_PROGS(BISON, bison byacc, [])#
AC_ARG_VAR(BISON,
[The grammar parser implementation to use. Defaults to the first
program found out of: `bison', `byacc'.])#
AC_ARG_VAR(YFLAGS,
[The list of arguments that will be passed by default to $BISON. 
Defaults to the empty string.])#
  if test -z "$BISON" ; then
      AC_MSG_ERROR([bison missing: this is fatal])  	
  fi 
  aida_bison_vers=`bison -V | grep "[[0-9]]\.[[0-9]]" | sed 's/.* \([[0-9]]\.[[0-9]]\).*/\1/'`
  if [[ `expr $aida_bison_vers \< 2.4` == 1 ]] ; then
	  if test $aida_tracing_ok = yes; then
		AIDA_TRACING_ENABLED=no
		AIDA_WARN_BISON="-> tracing options require at least bison 2.4, but got only $aida_bison_vers"
	  fi
  fi
])


# ---------------
# Check for tclsh
# ---------------
AC_DEFUN([AIDA_PROG_TCLSH],
[AC_CHECK_PROG([HAVE_TCLSH], [tclsh], [yes], [no])#
AC_ARG_VAR(HAVE_TCLSH,[The Tcl shell.])#
  if test -z "$HAVE_TCLSH" ; then
	  AIDA_WARN_TCLSH="-> no tclsh found on PATH"
  fi 
])


# ---------------
# Check for diff
# ---------------
AC_DEFUN([AIDA_PROG_DIFF],
[AC_CHECK_PROG([HAVE_DIFF], [diff], [yes], [no])#
AC_ARG_VAR(HAVE_DIFF,[The diff tool.])#
  if test -z "$HAVE_DIFF" ; then
	  AIDA_WARN_DIFF="-> no diff tool found on PATH"
  fi 
])



