#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "bin2hex.h"

/* Command line conversion from Hex strings to bin strings, which will
   fix endian issues between tape server and agent when we do decryption */

int main(int argc, char* argv[])
{
  char* rtnbuf;
  int binlen;

  if (argc != 2)
    {
      fprintf(stderr, "Usage: %s hexstring\n", argv[0]);
      return(1);
    }
  binlen = strlen(argv[1])/2;
  rtnbuf = unhexify_block(argv[1], binlen);
  write(fileno(stdout), rtnbuf, binlen);
  return(0);
}
