/*
RSSContextMenu.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

// Bookmark context menu
enum {
    SROpenRSSTag = 4600, 
    SROpenRSSInNewTabTag = 4601, 
    SROpenRSSInNewBackgroundTabTag = 4602, 
    SROpenRSSInNewWindowTag = 4603, 
    SROpenRSSInNewBackgroundWindowTag = 4604, 
    
    SROpenRSSLinkTag = 4610, 
    SROpenRSSLinkInNewTabTag = 4611, 
    SROpenRSSLinkInNewBackgroundTabTag = 4612, 
    SROpenRSSLinkInNewWindowTag = 4613, 
    SROpenRSSLinkInNewBackgroundWindowTag = 4614, 
    SROpenRSSLinkInTabsTag = 4615, 
    
    SRMakeArticlesPreviewedTag = 4620, 
    SRMakeAllArticlesPreviewedTag = 4621, 
    SRRefreshFeedTag = 4622, 
    SRRefreshAllFeedsTag = 4623, 
    
    SRDeleteFeedTag = 4630, 
    SRDeleteArticlseTag = 4631, 
    SRDeleteAllArticlesTag = 4632, 
};

@interface RSSContextMenu : NSObject
{
    IBOutlet id _contextMenu;
}

// Context menu
+ (NSMenu*)contextMenu;

@end
