/*
HMWindow.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

// Default keys
extern NSString*    HMWindowTexture;
typedef enum _HMWindowTextureType {
    HMWindowTextureAqua = 0, 
    HMWindowTextureMetal = 1, 
} HMWindowTextureType;

extern NSString*    HMWindowUseUnifiedToolbar;
extern NSString*    HMWindowIgnoreButtons;

@interface HMWindow : NSWindow
{
    NSMutableSet*   _mouseMoveListeners;
    BOOL            _passMenuValidationToDelegate;
}

// Mouse move listener
- (void)addMouseMoveListener:(id)listener;
- (void)removeMouseMoveListener:(id)listener;

// Menu validation
- (BOOL)passMenuValidationToDelegate;
- (void)setPassMenuValidationToDelegate:(BOOL)flag;

@end

@interface NSWindow (HMDTEx)

// Texture
- (BOOL)isMetal;

@end

@interface NSObject (HMMouseMoveListener)
- (void)hmWindow:(NSWindow*)window mouseMoved:(NSEvent*)event;
@end
