/*
HMKeyBinding.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMKeyBinding.h"

// Important information of key binding
// http://www.cocoabuilder.com/archive/message/2004/3/19/102023

@implementation HMKeyBinding

static NSString*        _controlString = nil;
static NSString*        _optionString = nil;
static NSString*        _shiftString = nil;
static NSString*        _commandString = nil;

static NSString*        _upArrowString = nil;
static NSString*        _downArrowString = nil;
static NSString*        _leftArrowString = nil;
static NSString*        _rightArrowString = nil;

static NSString*        _upArrowKeyString = nil;
static NSString*        _downArrowKeyString = nil;
static NSString*        _leftArrowKeyString = nil;
static NSString*        _rightArrowKeyString = nil;

static NSString*        _f1String = nil;
static NSString*        _f2String = nil;
static NSString*        _f3String = nil;
static NSString*        _f4String = nil;
static NSString*        _f5String = nil;
static NSString*        _f6String = nil;
static NSString*        _f7String = nil;
static NSString*        _f8String = nil;
static NSString*        _f9String = nil;
static NSString*        _f10String = nil;
static NSString*        _f11String = nil;
static NSString*        _f12String = nil;
static NSString*        _f13String = nil;
static NSString*        _f14String = nil;
static NSString*        _f15String = nil;
static NSString*        _f16String = nil;

static NSString*        _f1KeyString = nil;
static NSString*        _f2KeyString = nil;
static NSString*        _f3KeyString = nil;
static NSString*        _f4KeyString = nil;
static NSString*        _f5KeyString = nil;
static NSString*        _f6KeyString = nil;
static NSString*        _f7KeyString = nil;
static NSString*        _f8KeyString = nil;
static NSString*        _f9KeyString = nil;
static NSString*        _f10KeyString = nil;
static NSString*        _f11KeyString = nil;
static NSString*        _f12KeyString = nil;
static NSString*        _f13KeyString = nil;
static NSString*        _f14KeyString = nil;
static NSString*        _f15KeyString = nil;
static NSString*        _f16KeyString = nil;

static NSString*        _homeString = nil;
static NSString*        _endString = nil;
static NSString*        _pageUpString = nil;
static NSString*        _pageDownString = nil;

static NSString*        _homeKeyString = nil;
static NSString*        _endKeyString = nil;
static NSString*        _pageUpKeyString = nil;
static NSString*        _pageDownKeyString = nil;

static NSString*        _clearString = nil;
static NSString*        _helpString = nil;

static NSString*        _clearKeyString = nil;
static NSString*        _helpKeyString = nil;

static NSString*        _returnString = nil;
static NSString*        _enterString = nil;
static NSString*        _deleteString = nil;
static NSString*        _deleteForwardString = nil;
static NSString*        _escapeString = nil;
static NSString*        _tabString = nil;

static NSString*        _returnKeyString = nil;
static NSString*        _enterKeyString = nil;
static NSString*        _deleteKeyString = nil;
static NSString*        _deleteBackwardKeyString = nil;
static NSString*        _deleteForwardKeyString = nil;
static NSString*        _escapeKeyString = nil;
static NSString*        _tabKeyString = nil;

static NSDictionary*    _keyToVisibleDict = nil;

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

+ (void)load
{
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    if (!_controlString) {
        _controlString = [[NSString stringWithFormat:@"%C", 0x005E] retain];
        _optionString = [[NSString stringWithFormat:@"%C", 0x2325] retain];
        _shiftString = [[NSString stringWithFormat:@"%C", 0x21E7] retain];
        _commandString = [[NSString stringWithFormat:@"%C", 0x2318] retain];
        
        _upArrowString = [[NSString stringWithFormat:@"%C", 0x2191] retain];
        _downArrowString = [[NSString stringWithFormat:@"%C", 0x2193] retain];
        _leftArrowString = [[NSString stringWithFormat:@"%C", 0x2190] retain];
        _rightArrowString = [[NSString stringWithFormat:@"%C", 0x2192] retain];
        
        _upArrowKeyString = [[NSString stringWithFormat:@"%C", 0xf700] retain];
        _downArrowKeyString = [[NSString stringWithFormat:@"%C", 0xf701] retain];
        _leftArrowKeyString = [[NSString stringWithFormat:@"%C", 0xf702] retain];
        _rightArrowKeyString = [[NSString stringWithFormat:@"%C", 0xf703] retain];
        
        _f1String = @"F1";
        _f2String = @"F2";
        _f3String = @"F3";
        _f4String = @"F4";
        _f5String = @"F5";
        _f6String = @"F6";
        _f7String = @"F7";
        _f8String = @"F8";
        _f9String = @"F9";
        _f10String = @"F10";
        _f11String = @"F11";
        _f12String = @"F12";
        _f13String = @"F13";
        _f14String = @"F14";
        _f15String = @"F15";
        _f16String = @"F16";
        
        _f1KeyString = [[NSString stringWithFormat:@"%C", 0xf704] retain];
        _f2KeyString = [[NSString stringWithFormat:@"%C", 0xf705] retain];
        _f3KeyString = [[NSString stringWithFormat:@"%C", 0xf706] retain];
        _f4KeyString = [[NSString stringWithFormat:@"%C", 0xf707] retain];
        _f5KeyString = [[NSString stringWithFormat:@"%C", 0xf708] retain];
        _f6KeyString = [[NSString stringWithFormat:@"%C", 0xf709] retain];
        _f7KeyString = [[NSString stringWithFormat:@"%C", 0xf70a] retain];
        _f8KeyString = [[NSString stringWithFormat:@"%C", 0xf70b] retain];
        _f9KeyString = [[NSString stringWithFormat:@"%C", 0xf70c] retain];
        _f10KeyString = [[NSString stringWithFormat:@"%C", 0xf70d] retain];
        _f11KeyString = [[NSString stringWithFormat:@"%C", 0xf70e] retain];
        _f12KeyString = [[NSString stringWithFormat:@"%C", 0xf70f] retain];
        _f13KeyString = [[NSString stringWithFormat:@"%C", 0xf710] retain];
        _f14KeyString = [[NSString stringWithFormat:@"%C", 0xf711] retain];
        _f15KeyString = [[NSString stringWithFormat:@"%C", 0xf712] retain];
        _f16KeyString = [[NSString stringWithFormat:@"%C", 0xf713] retain];
        
        _homeString = [[NSString stringWithFormat:@"%C", 0x2196] retain];
        _endString = [[NSString stringWithFormat:@"%C", 0x2198] retain];
        _pageUpString = [[NSString stringWithFormat:@"%C", 0x21de] retain];
        _pageDownString = [[NSString stringWithFormat:@"%C", 0x21df] retain];
        
        _homeKeyString = [[NSString stringWithFormat:@"%C", 0xf729] retain];
        _endKeyString = [[NSString stringWithFormat:@"%C", 0xf72b] retain];
        _pageUpKeyString = [[NSString stringWithFormat:@"%C", 0xf72c] retain];
        _pageDownKeyString = [[NSString stringWithFormat:@"%C", 0xf72d] retain];
        
        _clearString = [[NSString stringWithFormat:@"%C", 0x2327] retain];
        _helpString = @"Help";
        
        _clearKeyString = [[NSString stringWithFormat:@"%C", 0xf739] retain];
        _helpKeyString = [[NSString stringWithFormat:@"%C", 0xf746] retain];
        
        _returnString = [[NSString stringWithFormat:@"%C", 0x21a9] retain];
        _enterString = [[NSString stringWithFormat:@"%C", 0x2305] retain];
        _deleteString = [[NSString stringWithFormat:@"%C", 0x232b] retain];
        _deleteForwardString = [[NSString stringWithFormat:@"%C", 0x2326] retain];
        _escapeString = [[NSString stringWithFormat:@"%C", 0x238b] retain];
        _tabString = [[NSString stringWithFormat:@"%C", 0x21e5] retain];
        
        _returnKeyString = [[NSString stringWithFormat:@"%C", 0xd] retain];
        _enterKeyString = [[NSString stringWithFormat:@"%C", 0x3] retain];
        _deleteKeyString = [[NSString stringWithFormat:@"%C", 0x8] retain];
        _deleteBackwardKeyString = [[NSString stringWithFormat:@"%C", 0x7f] retain];
        _deleteForwardKeyString = [[NSString stringWithFormat:@"%C", 0xf728] retain];
        _escapeKeyString = [[NSString stringWithFormat:@"%C", 0x1b] retain];
        _tabKeyString = [[NSString stringWithFormat:@"%C", 0x9] retain];
        
        _keyToVisibleDict = [[NSDictionary dictionaryWithObjectsAndKeys:
                _upArrowString, _upArrowKeyString, 
                _downArrowString, _downArrowKeyString, 
                _leftArrowString, _leftArrowKeyString, 
                _rightArrowString, _rightArrowKeyString, 
                
                _f1String, _f1KeyString, 
                _f2String, _f2KeyString, 
                _f3String, _f3KeyString, 
                _f4String, _f4KeyString, 
                _f5String, _f5KeyString, 
                _f6String, _f6KeyString, 
                _f7String, _f7KeyString, 
                _f8String, _f8KeyString, 
                _f9String, _f9KeyString, 
                _f10String, _f10KeyString, 
                _f11String, _f11KeyString, 
                _f12String, _f12KeyString, 
                _f13String, _f13KeyString, 
                _f14String, _f14KeyString, 
                _f15String, _f15KeyString, 
                _f16String, _f16KeyString, 
                
                _homeString, _homeKeyString, 
                _endString, _endKeyString, 
                _pageUpString, _pageUpKeyString, 
                _pageDownString, _pageDownKeyString, 
                
                _clearString, _clearKeyString, 
                _helpString, _helpKeyString, 
                
                _returnString, _returnKeyString, 
                _enterString, _enterKeyString, 
                _deleteString, _deleteKeyString, 
                _deleteString, _deleteBackwardKeyString, 
                _deleteForwardString, _deleteForwardKeyString, 
                _escapeString, _escapeKeyString, 
                _tabString, _tabKeyString, 
                nil] retain];
    }
    
    [pool release];
}

//--------------------------------------------------------------//
#pragma mark -- Key binding --
//--------------------------------------------------------------//

+ (NSString*)visibleKeyBindingWithKeyEquivalent:(NSString*)keyEquivalent 
        modifierFlags:(unsigned int)flags
{
    // Check arguments
    if ([keyEquivalent length] == 0) {
        return @"";
    }
    
    // Get unichar
    unichar c;
    c = [keyEquivalent characterAtIndex:0];
    
    // Check shift key
    BOOL    shift;
    shift = [[NSCharacterSet uppercaseLetterCharacterSet] characterIsMember:c];
    
    // Crate key binding string
    NSMutableString*    string;
    string = [NSMutableString string];
    if (flags & NSControlKeyMask) {
        [string appendString:_controlString];
    }
    if (flags & NSAlternateKeyMask) {
        [string appendString:_optionString];
    }
    if (shift || (flags & NSShiftKeyMask)) {
        [string appendString:_shiftString];
    }
    if (flags & NSCommandKeyMask) {
        [string appendString:_commandString];
    }
    
    NSString*   characterString;
    characterString = [_keyToVisibleDict objectForKey:keyEquivalent];
    if (!characterString) {
        characterString = [keyEquivalent capitalizedString];
    }
    [string appendString:characterString];
    
    return string;
}

@end
