/*
HMImageTextField.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMImageTextField.h"
#import "HMImageTextFieldCell.h"

@implementation HMImageTextField

+ (Class)cellClass
{
    // Use HMImageTextFieldCell class
    return [HMImageTextFieldCell class];
}

- (id)dragDelegate
{
    return _dragDelegate;
}

- (void)setDragDelegate:(id)delegate
{
    _dragDelegate = delegate;
}

- (void)mouseDown:(NSEvent*)event
{
    id  cell;
    cell = [self cell];
    if ([cell respondsToSelector:@selector(shouldImageTrackMouse:inRect:ofView:)]) {
        if ([cell shouldImageTrackMouse:event inRect:[self bounds] ofView:self]) {
            _preparingForDrag = YES;
            return;
        }
    }
    
    [super mouseDown:event];
}

- (void)mouseDragged:(NSEvent*)event
{
    if (_preparingForDrag) {
        id  cell;
        cell = [self cell];
        if ([cell respondsToSelector:@selector(imageTrackMouse:inRect:ofView:)]) {
            [cell imageTrackMouse:event inRect:[self bounds] ofView:self];
        }
        return;
    }
    
    [super mouseDragged:event];
}

@end
