% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfPolylog.R
\name{zipfPolylog}
\alias{zipfPolylog}
\alias{dzipfpolylog}
\alias{pzipfpolylog}
\alias{qzipfpolylog}
\alias{rzipfpolylog}
\title{The Zipf-Polylog Distribution (Zipf-Polylog).}
\usage{
dzipfpolylog(x, alpha, beta, log = FALSE, nSum = 1000)

pzipfpolylog(x, alpha, beta, log.p = FALSE, lower.tail = TRUE,
  nSum = 1000)

qzipfpolylog(p, alpha, beta, log.p = FALSE, lower.tail = TRUE,
  nSum = 1000)

rzipfpolylog(n, alpha, beta, nSum = 1000)
}
\arguments{
\item{x}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1} ).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0} ).}

\item{log, log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{nSum}{The number of terms used for computing the Polylogarithm function (Default = 1000).}

\item{lower.tail}{Logical; if TRUE (default), probabilities are \eqn{P[X \leq x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random values to return.}
}
\value{
{
\code{dzipfpolylog} gives the probability mass function
}
}
\description{
Probability mass function of the Zipf-Polylog distribution with parameters \eqn{\alpha} and \eqn{\beta}.
The support of the Zipf-Polylog distribution are the strictly positive integer numbers large or equal
than one.
}
\details{
The \emph{probability mass function} at a positive integer value \eqn{x} of the Zipf-Polylog distribution with
parameters \eqn{\alpha} and \eqn{\beta} is computed as follows:
}
\examples{
dzipfpolylog(1:10, 1.61, 0.98)
pzipfpolylog(1:10, 1.61, 0.98)
qzipfpolylog(0.8, 1.61, 0.98)
}
