% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{hierarchy}
\alias{hierarchy}
\title{Check aggregates defined by a hierarchical code list}
\usage{
hierarchy(
  values,
  labels,
  hierarchy,
  by = NULL,
  tol = 1e-08,
  na_value = TRUE,
  aggregator = sum,
  ...
)
}
\arguments{
\item{values}{bare (unquoted) name of a variable that holds values that
must aggregate according to the \code{hierarchy}.}

\item{labels}{bare (unquoted) name of variable holding a grouping variable (a code
from a hierarchical code list)}

\item{hierarchy}{\code{[data.frame]} defining a hierarchical code list. The
first column must contain (child) codes, and the second column contains their
corresponding parents.}

\item{by}{A bare (unquoted) variable or list of variable names that occur in
the data under scrutiny. The data will be split into groups according 
to these variables and the check is performed on each group.}

\item{tol}{\code{[numeric]} tolerance for equality checking}

\item{na_value}{\code{[logical]} or \code{NA}. Value assigned to values that
do not occurr in checks.}

\item{aggregator}{\code{[function]} that aggregates children to their parents.}

\item{...}{arguments passed to \code{aggregator} (e.g. \code{na.rm=TRUE}).}
}
\value{
A \code{logical} vector with the size of \code{length(values)}. Every
        element involved in an aggregation error is labeled \code{FALSE} (aggregate
        plus aggregated elements). Elements that are involved in correct
        aggregations are set to \code{TRUE}, elements that are not involved in 
        any check get the value \code{na_value} (by default: \code{TRUE}).
}
\description{
Check all aggregates defined by a code hierarchy.
}
\examples{
# We check some data against the built-in NACE revision 2 classification.
data(nace_rev2)
head(nace_rev2[1:4]) # columns 3 and 4 contain the child-parent relations.

d <- data.frame(
     nace   = c("01","01.1","01.11","01.12", "01.2")
   , volume = c(100 ,70    , 30    ,40     , 25    )
)
# It is possible to perform checks interactively
d$nacecheck <- hierarchy(d$volume, labels = d$nace, hierarchy=nace_rev2[3:4])
# we have that "01.1" == "01.11" + "01.12", but not "01" == "01.1" +  "01.2"
print(d)

# Usage as a valiation rule is as follows
rules <- validator(hierarchy(volume, labels = nace, hierarchy=validate::nace_rev_2[3:4]))
confront(d, rules)

# you can also pass a hierarchy as a reference, for example.

rules <- validator(hierarchy(volume, labels = nace, hierarchy=ref$nacecodes))
out <- confront(d, rules, ref=list(nacecodes=nace_rev2[3:4]))
summary(out)

# set a output to NA when a code does not occur in the code list.
d <- data.frame(
     nace   = c("01","01.1","01.11","01.12", "01.2", "foo")
   , volume = c(100 ,70    , 30    ,40     , 25     , 60)
)

d$nacecheck <- hierarchy(d$volume, labels = d$nace, hierarchy=nace_rev2[3:4]
                         , na_value = NA)
# we have that "01.1" == "01.11" + "01.12", but not "01" == "01.1" +  "01.2"
print(d)

}
\seealso{
Other cross-record-helpers: 
\code{\link{contains_exactly}()},
\code{\link{do_by}()},
\code{\link{exists_any}()},
\code{\link{hb}()},
\code{\link{is_complete}()},
\code{\link{is_linear_sequence}()},
\code{\link{is_unique}()}
}
\concept{cross-record-helpers}
