% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.utilities.R
\name{diff.control.list}
\alias{diff.control.list}
\alias{print.diff.control.list}
\title{Identify and the differences between two control lists.}
\usage{
\method{diff}{control.list}(x, y = eval(call(class(x)[[1L]])), ignore.environment = TRUE, ...)

\method{print}{diff.control.list}(x, ..., indent = "")
}
\arguments{
\item{x}{a \code{control.list}}

\item{y}{a reference \code{control.list}; defaults to the default
settings for \code{x}.}

\item{ignore.environment}{whether environment for
environment-bearing parameters (such as formulas and functions)
should be considered when comparing.}

\item{...}{Additional arguments to methods.}

\item{indent}{an argument for recursive calls, to facilitate
indentation of nested lists.}
}
\value{
An object of class \code{diff.control.list}: a named list with
an element for each non-identical setting. The element is either
itself a \code{diff.control.list} (if the setting is a control list)
or a named list with elements \code{x} and \code{y}, containing \code{x}'s and
\code{y}'s values of the parameter for that setting.
}
\description{
Identify and the differences between two control lists.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(diff.control.list)}: A print method.

}}
