% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.R, R/BIC_glm.R
\name{BIC.spmodel}
\alias{BIC.spmodel}
\alias{BIC.splm}
\alias{BIC.spautor}
\alias{BIC.spglm}
\alias{BIC.spgautor}
\title{Compute BIC of fitted model objects}
\usage{
\method{BIC}{splm}(object, ...)

\method{BIC}{spautor}(object, ...)

\method{BIC}{spglm}(object, ...)

\method{BIC}{spgautor}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}
where \code{estmethod} is \code{"ml"} or \code{"reml"}.}

\item{...}{Optionally more fitted model objects.}
}
\value{
If just one object is provided, a numeric value with the corresponding
BIC.

If multiple objects are provided, a \code{data.frame} with rows corresponding
to the objects and columns representing the number of parameters estimated
(\code{df}) and the BIC.
}
\description{
Compute BIC for one or
several fitted model objects for which a log-likelihood
value can be obtained.
}
\details{
When comparing models fit by maximum or restricted maximum
likelihood, the smaller the BIC, the better the fit. The theory of
BIC requires that the log-likelihood has been maximized, and hence,
no BIC methods exist for models where \code{estmethod} is not
\code{"ml"} or \code{"reml"}. Additionally, BIC comparisons between \code{"ml"}
and \code{"reml"} models are meaningless -- comparisons should only be made
within a set of models estimated using \code{"ml"} or a set of models estimated
using \code{"reml"}. BIC comparisons for \code{"reml"} must
use the same fixed effects. To vary the covariance parameters and
fixed effects simultaneously, use \code{"ml"}.

BIC is defined as \eqn{-2loglik + log(n)(estparams)}, where \eqn{n} is the sample size
and \eqn{estparams} is the number of estimated parameters. For \code{"ml"}, \eqn{estparams} is
the number of estimated covariance parameters plus the number of estimated
fixed effects. For \code{"reml"}, \eqn{estparams} is the number of estimated covariance
parameters.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
BIC(spmod)
}
