% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{optim_share}
\alias{optim_share}
\title{Use splitfngr with optim}
\usage{
optim_share(par, fngr, ...)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.
Will be passed to optim as par argument.}

\item{fngr}{A function that returns a list of two elements:
the function value and the gradient value.}

\item{...}{Arguments passed to optim, such as method,
lower, upper, control, and hessian.}
}
\value{
Results from running optim
}
\description{
Use R's optim function but pass in a single function
that returns both the function and gradient
together in a list. Useful when the function and
gradient are expensive to calculate and can be
calculated faster together than separate.
}
\examples{
quad_share <- function(x){list(sum(x^4), 4*x^3)}
optim_share(par=c(3, -5), quad_share, method="BFGS")
}
