% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjplot.R
\name{sjplot}
\alias{sjplot}
\alias{sjtab}
\title{Wrapper to create plots and tables within a pipe-workflow}
\usage{
sjplot(data, ..., fun = c("grpfrq", "xtab", "aov1", "likert"))

sjtab(data, ..., fun = c("xtab", "stackfrq"))
}
\arguments{
\item{data}{A data frame. May also be a grouped data frame (see 'Note' and
'Examples').}

\item{...}{Names of variables that should be plotted, and also further
arguments passed down to the \pkg{sjPlot}-functions. See 'Examples'.}

\item{fun}{Plotting function. Refers to the function name of \pkg{sjPlot}-functions.
See 'Details' and 'Examples'.}
}
\value{
See related sjp. and sjt.-functions.
}
\description{
This function has a pipe-friendly argument-structure, with the
             first argument always being the data, followed by variables that
             should be plotted or printed as table. The function then transforms
             the input and calls the requested sjp.- resp. sjt.-function
             to create a plot or table. \cr \cr
             Both \code{sjplot()} and \code{sjtab()} support grouped data frames.
}
\details{
Following \code{fun}-values are currently supported:
         \describe{
            \item{\code{"aov1"}}{calls \code{\link{sjp.aov1}}. The first
            two variables in \code{data} are used (and required) to create the plot.
            }
            \item{\code{"grpfrq"}}{calls \code{\link{plot_grpfrq}}. The first
            two variables in \code{data} are used (and required) to create the plot.
            }
            \item{\code{"likert"}}{calls \code{\link{plot_likert}}. \code{data}
            must be a data frame with items to plot.
            }
            \item{\code{"stackfrq"}}{calls \code{\link{tab_stackfrq}}.
            \code{data} must be a data frame with items to create the table.
            }
            \item{\code{"xtab"}}{calls \code{\link{plot_xtab}} or \code{\link{tab_xtab}}.
            The first two variables in \code{data} are used (and required)
            to create the plot or table.
            }
         }
}
\note{
The \code{...}-argument is used, first, to specify the variables from \code{data}
      that should be plotted, and, second, to name further arguments that are
      used in the subsequent plotting functions. Refer to the online-help of
      supported plotting-functions to see valid arguments.
      \cr \cr
      \code{data} may also be a grouped data frame (see \code{\link[dplyr]{group_by}})
      with up to two grouping variables. Plots are created for each subgroup then.
}
\examples{
library(dplyr)
data(efc)

# Grouped frequencies
efc \%>\% sjplot(e42dep, c172code, fun = "grpfrq")

# Grouped frequencies, as box plots
efc \%>\% sjplot(e17age, c172code, fun = "grpfrq",
               type = "box", geom.colors = "Set1")

\dontrun{
# table output of grouped data frame
efc \%>\%
  group_by(e16sex, c172code) \%>\%
  select(e42dep, n4pstu, e16sex, c172code) \%>\%
  sjtab(fun = "xtab", use.viewer = FALSE) # open all tables in browser}

}
