% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitsimts.R
\name{estimate}
\alias{estimate}
\title{Fit a Time Series Model to Data}
\usage{
estimate(model, Xt, method = "mle", demean = TRUE)
}
\arguments{
\item{model}{A time series model.}

\item{Xt}{A \code{vector} of time series data.}

\item{method}{A \code{string} indicating the method used for model fitting. 
Supported methods include \code{mle}, \code{yule-walker}, \code{gmwm}  and \code{rgmwm}.}

\item{demean}{A \code{boolean} indicating whether the model includes a mean / intercept term or not.}
}
\description{
This function can fit a time series model to data using different methods.
}
\examples{
Xt = gen_gts(300, AR(phi = c(0, 0, 0.8), sigma2 = 1))
plot(Xt)
estimate(AR(3), Xt)

Xt = gen_gts(300, MA(theta = 0.5, sigma2 = 1))
plot(Xt)
estimate(MA(1), Xt, method = "gmwm")

Xt = gen_gts(300, ARMA(ar = c(0.8, -0.5), ma = 0.5, sigma2 = 1))
plot(Xt)
estimate(ARMA(2,1), Xt, method = "rgmwm")

Xt = gen_gts(300, ARIMA(ar = c(0.8, -0.5), i = 1, ma = 0.5, sigma2 = 1))
plot(Xt)
estimate(ARIMA(2,1,1), Xt, method = "mle")

Xt = gen_gts(1000, SARIMA(ar = c(0.5, -0.25), i = 0, ma = 0.5, sar = -0.8, 
si = 1, sma = 0.25, s = 24, sigma2 = 1))
plot(Xt)
estimate(SARIMA(ar = 2, i = 0, ma = 1, sar = 1, si = 1, sma = 1, s = 24), Xt, 
method = "rgmwm")
}
\author{
Stéphane Guerrier and Yuming Zhang
}
