% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effDisc.R
\name{eff.disc-class}
\alias{eff.disc-class}
\alias{effDisc_new}
\title{Class \code{eff.disc}}
\usage{
effDisc_new(p, support, df, x = NULL)
}
\arguments{
\item{p}{the values of the distribution function at the support points.}

\item{support}{the support of the distribution.}

\item{df}{the effective degrees of freedom of the distribution.}

\item{x}{the sample of effectiveness scores used to fit the distribution. Defaults to
\code{NULL}.}
}
\value{
an object of class \code{eff.disc}, with the following components:
\tabular{rl}{
  \code{mean} \tab the expected value. \cr
  \code{var} \tab the variance. \cr
  \code{df} \tab the degrees of freedom (effective number of parameters) for
    \link[=effSelect]{model selection}. \cr
  \code{support} \tab the support of the distribution. \cr
  \code{data} \tab the sample data used to fit the distribution, or \code{NULL} if none. \cr
  \code{model} \tab a list with the family-specific data. \cr
}
}
\description{
This is the base S3 class for all discrete effectiveness distributions, which is itself a
subclass of \code{eff}. Function \code{effDisc_new} is the constructor of the class.
}
\details{
A new distribution family is expected to build new objects through this constructor. Default
implementations are readily available for methods \code{\link{deff}}, \code{\link{peff}},
\code{\link{qeff}} and \code{\link{reff}}.
}
\seealso{
\code{\link{effDisc}} for a list of currently implemented distribution families,
  \code{\link{effDiscFit}} to fit distributions, and \code{\link{effDisc-helper}} for helper
  functions.

  For continuous distributions, see \code{\link[=eff.cont-class]{eff.cont}}.
}
