% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling.R
\name{Split}
\alias{Split}
\title{Splitting observations into non-overlapping sets}
\usage{
Split(data, family = NULL, tau = c(0.5, 0.25, 0.25))
}
\arguments{
\item{data}{vector or matrix of data. In regression, this should be the
outcome data.}

\item{family}{type of regression model. This argument is defined as in
\code{\link[glmnet]{glmnet}}. Possible values include \code{"gaussian"}
(linear regression), \code{"binomial"} (logistic regression),
\code{"multinomial"} (multinomial regression), and \code{"cox"} (survival
analysis).}

\item{tau}{vector of the proportion of observations in each of the sets.}
}
\value{
A list of length \code{length(tau)} with sets of non-overlapping
  observation IDs.
}
\description{
Generates a list of \code{length(tau)} non-overlapping sets of observation
IDs.
}
\details{
With categorical outcomes (i.e. \code{family} argument is set to
  \code{"binomial"}, \code{"multinomial"} or \code{"cox"}), the split is done
  such that the proportion of observations from each of the categories in
  each of the sets is representative of that of the full sample.
}
\examples{
# Splitting into 3 sets
simul <- SimulateRegression()
ids <- Split(data = simul$ydata)
lapply(ids, length)

# Balanced splits with respect to a binary variable
simul <- SimulateRegression(family = "binomial")
ids <- Split(data = simul$ydata, family = "binomial")
lapply(ids, FUN = function(x) {
  table(simul$ydata[x, ])
})
}
