% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/command-args.R
\name{command_args}
\alias{command_args}
\title{Command line arguments}
\usage{
command_args(
  x = NULL,
  include = getOption("scribe.include", c("help", "version", NA_character_)),
  string = NULL
)
}
\arguments{
\item{x, string}{Command line arguments; see \code{\link[base:commandArgs]{base::commandArgs()}} for
default.  At least one parameter has to be \code{NULL}.  When \code{string} is
\code{NULL}, \code{x} is used, which defaults to \code{commandArgs(trailingOnly = TRUE)}.
Otherwise the value of \code{x} is converted to a \code{character}.  If \code{string} is
not \code{NULL}, \code{\link[=scan]{scan()}} will be used to split the value into a \code{character}
vector.}

\item{include}{Special default arguments to included.  See \verb{$initialize()}
in \link{scribeCommandArgs} for more details.}
}
\value{
A \link{scribeCommandArgs} object
}
\description{
Make a new \link{scribeCommandArgs} object
}
\examples{
command_args()
command_args(c("-a", 1, "-b", 2))
command_args(string = "-a 1 -b 2")
}
\seealso{
Other scribe: 
\code{\link{new_arg}()},
\code{\link{scribeArg-class}},
\code{\link{scribeCommandArgs-class}}
}
\concept{scribe}
