% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{export_as_tsv}
\alias{export_as_tsv}
\alias{import_from_tsv}
\title{Create Enriched flat value table with paths}
\usage{
export_as_tsv(
  tt,
  file = NULL,
  path_fun = collapse_path,
  value_fun = collapse_values
)

import_from_tsv(file)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a
populated table.}

\item{file}{character(1). The path of the file to written to or read from.}

\item{path_fun}{function. Function to transform paths into single-string
row/column names.}

\item{value_fun}{function. Function to transform cell values into cells of
the data.frame. Defaults to \code{collapse_values} which creates strings
where multi-valued cells are collapsed together, separated by \code{|}.}
}
\value{
\code{NULL} silently for \code{export_as_tsv}, a data.frame with
re-constituted list values for \code{export_as_tsv}.
}
\description{
This function creates a flat tabular file of cell values and
corresponding paths via \code{\link{path_enriched_df}}. I then
writes that data.frame out as a tsv file.
}
\details{
By default (ie when \code{value_func} is not specified,
List columns where at least one value has length > 1 are collapsed
to character vectors by collapsing the list element with \code{"|"}.
}
\note{
There is currently no round-trip capability for this type of export.
You can read values exported this way back in via \code{import_from_tsv}
but you will receive only the data.frame version back, NOT a \code{TableTree}.
}
