% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.rpqueue}
\alias{as.rpqueue}
\title{Create a pre-filled rpqueue from a given input}
\usage{
as.rpqueue(x, ...)
}
\arguments{
\item{x}{input to convert to an rpqueue.}

\item{...}{additional arguments to be passed to or from methods (ignored).}
}
\value{
a new rpqueue.
}
\description{
Creates a new rpqueue from a given input. Coerces input to a
list first using \code{as.list}, the element at \code{x[[1]]} becomes the front of the new queue.
}
\details{
Runs in \eqn{O(N)} in the size of the input. Because data.frames return a list of
columns when run through \code{as.list}, running \code{as.rpqueue} results in a queue of
columns, rather than a queue of rows.
}
\examples{
d <- as.rpqueue(1:20)
print(d)

## A queue with only 5 elements, one for each column
oops <- as.rdeque(iris)
print(oops)
}
\seealso{
\code{\link{rpqueue}}.
}

