% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_key.R
\name{add_key}
\alias{add_key}
\title{Add index  keys to a vector or data frame or list or matrix}
\usage{
add_key(vector)
}
\arguments{
\item{vector}{vector or data frame to transform}
}
\value{
a transformed list containing keys along with vector values
}
\description{
Index a vector or lists and convert to a list of objects
}
\examples{
#ex1 simple conversion of a vector
rti2 <- c("rpkg","obinna", "obianom")
add_key(rti2)
rti2

#ex2 add keys to a vector content for use in downstream processes
ver1 <- c("Test 1","Test 2","Test 3")
add_key(ver1)

for(i in ver1){
  message(sprintf("\%s is the key for this \%s", i$key, i$value))
}

}
