% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric.R
\name{numeric_}
\alias{numeric_}
\alias{numeric_bounded}
\alias{numeric_left_bounded}
\alias{numeric_right_bounded}
\alias{numeric_positive}
\alias{numeric_negative}
\title{Numeric generators}
\usage{
numeric_(len = c(1L, 10L), any_na = FALSE, big_num = FALSE)

numeric_bounded(left, right, len = c(1L, 10L), any_na = FALSE)

numeric_left_bounded(left, len = c(1L, 10L), any_na = FALSE, big_num = FALSE)

numeric_right_bounded(right, len = c(1L, 10L), any_na = FALSE, big_num = FALSE)

numeric_positive(len = c(1L, 10L), any_na = FALSE, big_num = FALSE)

numeric_negative(len = c(1L, 10L), any_na = FALSE, big_num = FALSE)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}

\item{any_na}{Whether \code{NA} values should be allowed.}

\item{big_num}{Should integers or doubles near the
maximum size be included? This may cause problems because
if the result of a computation results in a number
larger than the maximum an integer will be silently
coerced to a double and a double will return \code{Inf}.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
A set of generators for numeric vectors. Numeric vectors can be either
integer or double vectors.
}
\examples{
numeric_() \%>\% show_example()
numeric_(big_num = TRUE) \%>\% show_example()
numeric_bounded(left = -5L, right = 5L) \%>\% show_example()
numeric_(len = 10L, any_na = TRUE) \%>\% show_example()
}
