% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso.R
\name{lasso}
\alias{lasso}
\alias{lasso.fit}
\title{Lasso with penalty parameter selection}
\usage{
lasso(
  x,
  y,
  lambda = seq(1, 0, length.out = 50),
  mode = c("fraction", "lambda"),
  standardize = TRUE,
  intercept = TRUE,
  splits = foldControl(),
  cost = rmspe,
  selectBest = c("hastie", "min"),
  seFactor = 1,
  ncores = 1,
  cl = NULL,
  seed = NULL,
  ...
)

lasso.fit(
  x,
  y,
  lambda = seq(1, 0, length.out = 50),
  mode = c("fraction", "lambda"),
  standardize = TRUE,
  intercept = TRUE,
  ...
)
}
\arguments{
\item{x}{a numeric matrix containing the predictor variables.}

\item{y}{a numeric vector containing the response variable.}

\item{lambda}{for \code{lasso}, a numeric vector of non-negative values to
be used as penalty parameter.  For \code{lasso.fit}, a single non-negative
value to be used as penalty parameter.}

\item{mode}{a character string specifying the type of penalty parameter.  If
\code{"fraction"}, \code{lambda} gives the fractions of the smallest value
of the penalty parameter that sets all coefficients to 0 (hence all values
of \code{lambda} should be in the interval [0,1] in that case).  If
\code{"lambda"}, \code{lambda} gives the grid of values for the penalty
parameter directly.}

\item{standardize}{a logical indicating whether the predictor variables
should be standardized to have unit variance (the default is \code{TRUE}).}

\item{intercept}{a logical indicating whether a constant term should be
included in the model (the default is \code{TRUE}).}

\item{splits}{an object giving data splits to be used for prediction error
estimation (see \code{\link[perry]{perryTuning}}).}

\item{cost}{a cost function measuring prediction loss (see
\code{\link[perry]{perryTuning}} for some requirements).  The
default is to use the root mean squared prediction error (see
\code{\link[perry]{cost}}).}

\item{selectBest, seFactor}{arguments specifying a criterion for selecting
the best model (see \code{\link[perry]{perryTuning}}).  The default is to
use a one-standard-error rule.}

\item{ncores, cl}{arguments for parallel computing (see
\code{\link[perry]{perryTuning}}).}

\item{seed}{optional initial seed for the random number generator (see
\code{\link{.Random.seed}} and \code{\link[perry]{perryTuning}}).}

\item{\dots}{for \code{lasso}, additional arguments to be passed to the
prediction loss function \code{cost}.  For \code{lasso.fit}, additional
arguments to be passed to \code{\link[lars]{lars}}.}
}
\value{
For \code{lasso}, an object of class \code{"perryTuning"}, see
\code{\link[perry]{perryTuning}}).  It contains information on the
prediction error criterion, and includes the final model with the optimal
tuning paramter as component \code{finalModel}.

For \code{lasso.fit}, an object of class \code{lasso} with the following
components:
\describe{
  \item{\code{lambda}}{numeric; the value of the penalty parameter.}
  \item{\code{coefficients}}{a numeric vector containing the coefficient
  estimates.}
  \item{\code{fitted.values}}{a numeric vector containing the fitted values.}
  \item{\code{residuals}}{a numeric vector containing the residuals.}
  \item{\code{standardize}}{a logical indicating whether the predictor
  variables were standardized to have unit variance.}
  \item{\code{intercept}}{a logical indicating whether the model includes a
  constant term.}
  \item{\code{muX}}{a numeric vector containing the means of the predictors.}
  \item{\code{sigmaX}}{a numeric vector containing the standard deviations of
  the predictors.}
  \item{\code{mu}}{numeric; the mean of the response.}
  \item{\code{call}}{the matched function call.}
}
}
\description{
Fit lasso models and select the penalty parameter by estimating the
respective prediction error via (repeated) \eqn{K}-fold cross-validation,
(repeated) random splitting (also known as random subsampling or Monte Carlo
cross-validation), or the bootstrap.
}
\examples{
## load data
data("Bundesliga")
Bundesliga <- Bundesliga[, -(1:2)]
f <- log(MarketValue) ~ Age + I(Age^2) + .
mf <- model.frame(f, data=Bundesliga)
x <- model.matrix(terms(mf), mf)[, -1]
y <- model.response(mf)

## set up repeated random splits
splits <- splitControl(m = 40, R = 10)

## select optimal penalty parameter
fit <- lasso(x, y, splits = splits, seed = 2014)
fit

## plot prediction error results
plot(fit, method = "line")
}
\references{
Tibshirani, R. (1996) Regression shrinkage and selection via the
lasso.  \emph{Journal of the Royal Statistical Society, Series B},
\bold{58}(1), 267--288.
}
\seealso{
\code{\link[perry]{perryTuning}}, \code{\link[lars]{lars}}
}
\author{
Andreas Alfons
}
\keyword{regression}
\keyword{robust}
