% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_modulate.R
\name{interactive_modulate}
\alias{interactive_modulate}
\title{interactive modulating}
\usage{
interactive_modulate(
  image,
  range_max_brightness = 200,
  range_max_saturation = 200,
  range_max_hue = 200,
  resolution = 0.1,
  return_param = FALSE,
  scale
)
}
\arguments{
\item{image}{a magick image object}

\item{range_max_brightness}{define maximum in slider of brightness. must be positive.}

\item{range_max_saturation}{define maximum in slider of saturation. must be positive.}

\item{range_max_hue}{define maximum in slider of hue. must be positive.}

\item{resolution}{resolution of slider}

\item{return_param}{If return_param is TRUE, returns values of brightness and saturation and hue. If return_param is FALSE, returns a magick image object.}

\item{scale}{geometry to be passed to image_scale function of magick package. image is scaled just for preview and result image is not scaled if scale is given.}
}
\value{
a magick image object or values of brightness, saturation, and hue
}
\description{
Using image_modulate of 'magick' interactively.
brightness and saturation and hue are parameters of image_modulate. See reference manual of 'magick' for detail.
}
\examples{
\donttest{
interactive_modulate(wizard)
}
}
\author{
Shota Ochi
}
