% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_kable.R
\name{save_kable}
\alias{save_kable}
\title{Save kable to files}
\usage{
save_kable(
  x,
  file,
  bs_theme = "simplex",
  self_contained = TRUE,
  extra_dependencies = NULL,
  ...,
  latex_header_includes = NULL,
  keep_tex = FALSE,
  density = 300
)
}
\arguments{
\item{x}{A piece of HTML code for tables, usually generated by kable and
kableExtra}

\item{file}{save to files. If the input table is in HTML and the output file
ends with \code{.png}, \code{.pdf} and \code{.jpeg}, \code{webshot2} will be used to do the
conversion.}

\item{bs_theme}{Which Bootstrap theme to use}

\item{self_contained}{Will the files be self-contained?}

\item{extra_dependencies}{Additional HTML dependencies. For example,
\verb{list(}}

\item{...}{Additional variables being passed to \code{webshot2::webshot}. This
is for HTML only.}

\item{latex_header_includes}{A character vector of extra LaTeX header stuff.
Each element is a row. You can have things like
\code{c("\\\\\\\\usepackage{threeparttable}", "\\\\\\\\usepackage{icons}")}  You could
probably add your language package here if you use non-English text in your
table, such as \verb{\\\\\\\\usepackage[magyar]\{babel\}}.}

\item{keep_tex}{A T/F option to control if the latex file that is initially created
should be kept. Default is \code{FALSE}.}

\item{density}{density argument passed to magick if needed. Default is 300.}
}
\description{
Save kable to files
}
\examples{
\dontrun{
library(kableExtra)

kable(mtcars[1:5, ], "html") \%>\%
  kable_styling("striped") \%>\%
  row_spec(1, color = "red") \%>\%
  save_kable("inst/test.pdf")
}
}
