% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kernel_loader.R
\name{kernL}
\alias{kernL}
\alias{kernL.formula}
\title{Load the kernel matrices for I-prior models}
\usage{
kernL(y, ..., kernel = "linear", interactions = NULL,
  est.lambda = TRUE, est.hurst = FALSE, est.lengthscale = FALSE,
  est.offset = FALSE, est.psi = TRUE, fixed.hyp = NULL, lambda = 1,
  psi = 1, nystrom = FALSE, nys.seed = NULL, model = list(),
  train.samp, test.samp)

\method{kernL}{formula}(formula, data, kernel = "linear",
  one.lam = FALSE, est.lambda = TRUE, est.hurst = FALSE,
  est.lengthscale = FALSE, est.offset = FALSE, est.psi = TRUE,
  fixed.hyp = NULL, lambda = 1, psi = 1, nystrom = FALSE,
  nys.seed = NULL, model = list(), train.samp, test.samp, ...)
}
\arguments{
\item{y}{Vector of response variables}

\item{...}{Only used when fitting using non-formula, enter the variables
(vectors or matrices) separated by commas.}

\item{kernel}{Character vector indicating the type of kernel for the
variables. Available choices are: \itemize{ \item{\code{"linear"} -
(default) for the linear kernel} \item{\code{"canonical"} - alternative
name for \code{"linear"}} \item{\code{"fbm"}, \code{"fbm,0.5"} - for the
fBm kernel with Hurst coefficient 0.5 (default)} \item{\code{"se"},
\code{"se,1"} - for the SE kernel with lengthscale 1 (default)}
\item{\code{"poly"}, \code{"poly2"}, \code{"poly2,0"} - for the polynomial
kernel of degree 2 with offset 0 (default)} \item{\code{"pearson" - for the
Pearson kernel}}} The \code{kernel} argument can also be a vector of length
equal to the number of variables, therefore it is possible to specify
different kernels for each variables. Note that factor type variables are
assigned the Pearson kernel by default, and that non-factor types can be
forced to use the Pearson kernel (not recommended).}

\item{interactions}{Character vector to specify the interaction terms. When
using formulas, this is specified automatically, so is not required. Syntax
is \code{"a:b"} to indicate variable \code{a} interacts with variable
\code{b}.}

\item{est.lambda}{Logical. Estimate the scale parameters? Defaults to
\code{TRUE}.}

\item{est.hurst}{Logical. Estimate the Hurst coefficients for fBm kernels?
Defaults to \code{FALSE}.}

\item{est.lengthscale}{Logical. Estimate the lengthscales for SE kernels?
Defaults to \code{FALSE}.}

\item{est.offset}{Logical. Estimate the offsets for polynomial kernels?
Defaults to \code{FALSE}.}

\item{est.psi}{Logical. Estimate the error precision? Defaults to
\code{TRUE}.}

\item{fixed.hyp}{Logical. If \code{TRUE}, then no hyperparameters are
estimated, i.e. all of the above \code{est.x} are set to \code{FALSE}, and
vice versa. If \code{NULL} (default) then all of the \code{est.x} defaults
are respected.}

\item{lambda}{Initial/Default scale parameters. Relevant especially if
\code{est.lambda = FALSE}.}

\item{psi}{Initial/Default value for error precision. Relevant especially if
\code{est.psi = FALSE}.}

\item{nystrom}{Either logical or an integer indicating the number of Nystrom
samples to take. Defaults to \code{FALSE}. If \code{TRUE}, then
approximately 10\% of the sample size is used for the Nystrom
approximation.}

\item{nys.seed}{The random seed for the Nystrom sampling. Defaults to
\code{NULL}, which means the random seed is not fixed.}

\item{model}{DEPRECATED.}

\item{train.samp}{(Optional) A vector indicating which of the data points
should be used for training, and the remaining used for testing.}

\item{test.samp}{(Optional) Similar to \code{train.samp}, but on test samples
instead.}

\item{formula}{The formula to fit when using formula interface.}

\item{data}{Data frame containing variables when using formula interface.}

\item{one.lam}{Logical. When using formula input, this is a convenient way of
letting the function know to treat all variables as a single variable (i.e.
shared scale parameter). Defaults to \code{FALSE}.}
}
\value{
An \code{ipriorKernel} object which contains the relevant material to
  be passed to the \code{iprior} function for model fitting.
}
\description{
Load the kernel matrices for I-prior models
}
\examples{

str(ToothGrowth)
(mod <- kernL(y = ToothGrowth$len,
               supp = ToothGrowth$supp,
               dose = ToothGrowth$dose,
               interactions = "1:2"))
kernL(len ~ supp * dose, data = ToothGrowth)  # equivalent formula call

# Choosing different kernels
str(stackloss)
kernL(stack.loss ~ ., stackloss, kernel = "fbm")  # all fBm kernels
kernL(stack.loss ~ ., stackloss, kernel = "FBm")  # cApS dOn't MatTeR
kernL(stack.loss ~ ., stackloss,
       kernel = c("linear", "se", "poly3"))  # different kernels

# Sometimes the print output is too long, can use str() options here
print(mod, strict.width = "cut", width = 30)

}
\seealso{
\link[=iprior]{iprior}
}
