% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_design_maxcombo.R
\name{fixed_design_maxcombo}
\alias{fixed_design_maxcombo}
\title{Fixed design using MaxCombo method}
\usage{
fixed_design_maxcombo(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate,
  rho = c(0, 0, 1),
  gamma = c(0, 1, 0),
  tau = rep(-1, 3)
)
}
\arguments{
\item{alpha}{One-sided Type I error (strictly between 0 and 1).}

\item{power}{Power (\code{NULL} to compute power or strictly between 0
and \code{1 - alpha} otherwise).}

\item{ratio}{Experimental:Control randomization ratio.}

\item{study_duration}{Study duration.}

\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{rho}{A vector of numbers paring with gamma and tau for maxcombo test.}

\item{gamma}{A vector of numbers paring with rho and tau for maxcombo test.}

\item{tau}{A vector of numbers paring with gamma and rho for maxcombo test.}
}
\value{
A table.
}
\description{
Computes fixed design sample size (given power) or power (given sample size)
for MaxCombo method.
Returns a list with a basic summary.
}
\examples{
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_maxcombo(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = c(0, 0.5), gamma = c(0, 0), tau = c(-1, -1)
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_maxcombo(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = c(0, 0.5), gamma = c(0, 0), tau = c(-1, -1)
)
x \%>\% summary()
}
