% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_design_fh.R
\name{fixed_design_fh}
\alias{fixed_design_fh}
\title{Fixed design using Fleming-Harrington method}
\usage{
fixed_design_fh(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate,
  rho = 0,
  gamma = 0
)
}
\arguments{
\item{alpha}{One-sided Type I error.}

\item{power}{Power (\code{NULL} to compute power or strictly between 0
and \code{1 - alpha} otherwise).}

\item{ratio}{Experimental:Control randomization ratio (not yet implemented).}

\item{study_duration}{Study duration.}

\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{rho}{test parameter in Fleming-Harrington method.}

\item{gamma}{test parameter in Fleming-Harrington method.}
}
\value{
A table.
}
\description{
Computes fixed design sample size (given power) or power (given sample size)
for Fleming-Harrington method (Farrington and Manning, 1990).
Returns a list with a basic summary.
}
\examples{
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_fh(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = 1, gamma = 1
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_fh(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = 1, gamma = 1
)
x \%>\% summary()
}
