% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mukherjee.R
\name{graphMomentsClustering}
\alias{graphMomentsClustering}
\title{Graph clustering method using graph moments}
\usage{
graphMomentsClustering(Networks, nbMoments = 3, nbClusters)
}
\arguments{
\item{Networks}{list of adjacency matrices}

\item{nbMoments}{order of the largest graph moments to be considered}

\item{nbClusters}{desired number of clusters}
}
\value{
vector with the clustering of the networks
}
\description{
Graph clustering method based on graph moments by Mukherjee et al. (2017)
}
\examples{
param <- vector('list', 3)
param[[1]] <- list(prop = 1/3, # component 1 :  alpha > beta
                   alpha = .04,
                   beta = .02,
                   deltaIn = 100,
                   deltaOut = 100,
                   R = 500
)
param[[2]] <- list(prop = 1/3, # component 2 : just permute alpha and beta ;
                   alpha = .01,
                   beta = .02,
                   deltaIn = 100,
                   deltaOut = .1,
                   R = 1000
)
param[[3]] <- list(prop = 1/3, # component 3 : alpha=beta
                   alpha = .015,
                   beta = .015,
                   deltaIn = .1,
                   deltaOut = .1,
                   R = 1000
)
obs <- sampleDPAMixture(M=20, param)
res <- graphMomentsClustering(obs$listAdj, 3, 3)
table(res, obs$graphGroups)
}
