% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{anova.zeroinflation}
\alias{anova.zeroinflation}
\title{Comparison of nested models for Regression Models to deal with Zero-Excess in Count Data}
\usage{
\method{anova}{zeroinflation}(
  object,
  ...,
  test = c("wald", "lr", "score", "gradient"),
  verbose = TRUE,
  submodel = c("counts", "zeros")
)
}
\arguments{
\item{object}{an object of the class \emph{zeroinflation}.}

\item{...}{another objects of the class \emph{zeroinflation}.}

\item{test}{an (optional) character string which allows to specify the required test. The available options are: Wald ("wald"),
Rao's score ("score"), likelihood ratio ("lr") and Terrell's gradient ("gradient") tests. By default, \code{test} is
set to be "wald".}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. By default, \code{verbose}
is set to be TRUE.}

\item{submodel}{an (optional) character string which allows to specify the model: "counts" or "zeros". By default,
\code{submodel} is set to be "counts".}
}
\value{
A matrix with the following three columns:
\itemize{
\item \code{Chi:}{ The value of the statistic of the test,}
\item \code{Df:}{ The number of degrees of freedom,}
\item \code{Pr(>Chi):}{ The \emph{p}-value of the test \emph{test} computed using the Chi-square distribution.}
}
}
\description{
Allows to compare nested models for regression models used to deal with zero-excess in count data.
The comparisons are performed by using the Wald, score, gradient or likelihood ratio tests.
}
\examples{
####### Example 1: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit1 <- zeroinf(art ~ fem + kid5 + ment | ment, family="nb1(log)", data = bioChemists)
anova(fit1,test="wald")
anova(fit1,test="lr")
anova(fit1,test="score")
anova(fit1,test="gradient")

fit2 <- zeroalt(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)
anova(fit2,submodel="zeros",test="wald")
anova(fit2,submodel="zeros",test="lr")
anova(fit2,submodel="zeros",test="score")
anova(fit2,submodel="zeros",test="gradient")

}
\references{
Buse A. (1982) The Likelihood Ratio, Wald, and Lagrange Multiplier Tests: An Expository Note.
                            \emph{The American Statistician} 36, 153-157.

Terrell G.R. (2002) The gradient statistic. \emph{Computing Science and Statistics} 34, 206–215.
}
