% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{PAC}
\alias{PAC}
\title{Pardo-Alonso's Criterion for Generalized Estimating Equations}
\usage{
PAC(..., verbose = TRUE)
}
\arguments{
\item{...}{one or several objects of the class \emph{glmgee}.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A \code{data.frame} with the values of the PAC for each \emph{glmgee} object in the input.
}
\description{
Computes the Pardo-Alonso's criterion (PAC) for one or more objects of the class glmgee.
}
\examples{
###### Example 1: Effect of ozone-enriched atmosphere on growth of sitka spruces
data(spruces)
mod1 <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod1, id=tree, family=Gamma(log), data=spruces)
fit2 <- update(fit1, corstr="AR-M-dependent")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Exchangeable")
PAC(fit1, fit2, fit3, fit4)

###### Example 2: Treatment for severe postnatal depression
data(depression)
mod2 <- depressd ~ visit + group
fit1 <- glmgee(mod2, id=subj, family=binomial(logit), data=depression)
fit2 <- update(fit1, corstr="AR-M-dependent")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Exchangeable")
PAC(fit1, fit2, fit3, fit4)

###### Example 3: Treatment for severe postnatal depression (2)
mod3 <- dep ~ visit*group
fit1 <- glmgee(mod3, id=subj, family=gaussian(identity), data=depression)
fit2 <- update(fit1, corstr="AR-M-dependent")
fit3 <- update(fit1, corstr="Exchangeable")
PAC(fit1, fit2, fit3)

}
\references{
Pardo M.C. and Alonso R. (2019) Working correlation structure selection in GEE analysis.
\emph{Statistical Papers} 60:1447–1467.
}
\seealso{
\link{QIC}, \link{CIC}, \link{RJC}, \link{AGPC}, \link{SGPC}, \link{GHYC}
}
