<!-- This is heavily adapted version of
the Benevolent dictator governance model by Ross
Gardler and Gabriel Hanganu licensed under a Creative Commons 
Attribution-ShareAlike 4.0 International License. -->

# Roles and responsibilities

This project has a large community of __users__ and __contributors__, a team of __core developers__, and a __project lead__.

## Users

People who create visualizations with ggplot2 are the most important members of the community; without these users, this project would have no purpose.

Users are encouraged to participate in the life of the project and the community as much as possible. User contributions help ensure that the project is satisfying users' needs. Common user activities include (but are not limited to):

- evangelising about the project
- asking and answering on community forums
- providing moral support (a 'thank you' goes a long way)

Users who continue to engage with the project and its community will often find themselves becoming more and more involved. Such users may then go on to become contributors, as described above.

## Contributors

Contributors interact with the project on GitHub by filing new issues, improving existing issues, or submitting pull requests. Anyone can become a contributor: there is no expectation of commitment to the project, no required set of skills, and no selection process. The only obligation is to follow the [code of conduct](.github/CODE_OF_CONDUCT.md).

Specific advice for contributing to the project can be found in
[CONTRIBUTING.md](https://github.com/tidyverse/ggplot2/blob/master/CONTRIBUTING.md).

## Core developers

Core developers are collectively responsible for day-to-day development of the package, including responding to issues and reviewing pull requests. They are GitHub administrators and [package authors](https://github.com/tidyverse/ggplot2/blob/master/DESCRIPTION#L8), which means that they have the ability to make changes to project code, and receive credit when others cite the package.

While core developers can modify code directly, this ability is rarely used. Instead, changes are proposed as pull requests, and are only merged after they have been reviewed by at least one other core developer. Changes to the API (especially breaking changes) must also be approved by the project lead. 

Core developers are recruited from contributors. An invitation to join the core team can be extended to anyone who has made a major contribution, either through a small number of large changes, or a consistent pattern of smaller contributions. Any existing core developer can propose a contributor be invited to the core team by emailing the project lead. The project lead will the confirm the invitation with the other core developers.

The core developers of ggplot2 are:

* [Winston Chang](https://github.com/wch)
* [Lionel Henry](https://github.com/lionel-)
* [Thomas Lin Pedersen](https://github.com/thomasp85)
* [Kohske Takahashi](https://github.com/kohske)
* [Claus Wilke](https://github.com/clauswilke)
* [Kara Woo](https://github.com/karawoo)
* [Hiroaki Yutani](https://github.com/yutannihilation)
* [Dewey Dunnington](https://github.com/paleolimbot)

All core developers are bound by the [code of conduct](CODE_OF_CONDUCT.md).

## Project lead

The project lead, [Hadley Wickham](http://github.com/hadley), is responsible for:

* Setting, and clearly communication the strategic objectives of the project.
* Mediating any conflicts amongst the core developers.
* Ensuring that the project survives in the long term.

The project lead is bound by the [code of conduct](CODE_OF_CONDUCT.md).

# Decision-making process

This project makes decisions according to a consensus model where suggestions are considered and discussed between the community and core developers, typically in GitHub issues. Where consensus cannot be reached, the project lead's word is final. If the community questions a decision, the project lead may review it and either uphold or reverse it.
