% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{wrap_string}
\alias{wrap_string}
\alias{wrap_txt}
\title{Wrap a string to within a maximum width}
\usage{
wrap_string(str, max_width)

wrap_txt(txt, max_width)
}
\arguments{
\item{str}{character(1). String to be wrapped}

\item{max_width}{numeric(1). Maximum width, in characters, that the
text should be wrapped at.}

\item{txt}{character. Vector of strings that should be (independently)
text-wrapped.}
}
\value{
a string (`wrap_string` or character vector (`wrap_txt`) containing
the word-wrapped content.
}
\description{
Wrap a string to within a maximum width
}
\details{
word      wrapping     happens      as      with
    \link[base:strwrap]{base::strwrap}    with     the    following
    exception: individual  words which are longer  than `max_width`
    are  broken  up  in a  way  that  fits  with  the rest  of  the
    wordwrapping.
}
