% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{pagdfrow}
\alias{pagdfrow}
\title{Create row of pagination data frame}
\usage{
pagdfrow(
  row,
  nm = obj_name(row),
  lab = obj_label(row),
  rnum,
  pth,
  sibpos = NA_integer_,
  nsibs = NA_integer_,
  extent = nlines(row, colwidths),
  colwidths = NULL,
  repext = 0L,
  repind = integer(),
  indent = 0L,
  rclass = class(row),
  nrowrefs = 0L,
  ncellrefs = 0L,
  nreflines = 0L,
  force_page = FALSE,
  page_title = NA_character_,
  trailing_sep = NA_character_
)
}
\arguments{
\item{row}{ANY. Object representing the row, which is used for default values of \code{nm}, \code{lab},
\code{extent} and \code{rclass} if provided. Must have methods for \code{obj_name}, \code{obj_label},
and \code{nlines}, respectively, for default values of \code{nm}, \code{lab} and \code{extent} to
be retrieved, respectively.}

\item{nm}{character(1). Name}

\item{lab}{character(1). Label}

\item{rnum}{numeric(1). Absolute rownumber}

\item{pth}{character or NULL. Path within larger table}

\item{sibpos}{integer(1). Position amongst sibling rows}

\item{nsibs}{integer(1). Number of siblings (including self).}

\item{extent}{numberic(1). Number of lines required to print the row}

\item{colwidths}{numeric. Column widths}

\item{repext}{integer(1). Number of lines required to reprint all context for this row if it appears directly after pagination.}

\item{repind}{integer. Vector of row numbers to be reprinted if this row appears directly after pagination.}

\item{indent}{integer. Indent}

\item{rclass}{character(1). Class of row object.}

\item{nrowrefs}{integer(1). Number of row referential footnotes for this row}

\item{ncellrefs}{integer(1). Number of cell referential footnotes for the cells in this row}

\item{nreflines}{integer(1). Total number of lines required by all referential footnotes}

\item{force_page}{logical(1). Currently Ignored.}

\item{page_title}{logical(1). Currently Ignored.}

\item{trailing_sep}{character(1). The string to used as a separator below this row during printing (or
`NA_character_` for no separator).}
}
\value{
a single row data.frame with the columns appropriate for a pagination info data frame.
}
\description{
Create row of pagination data frame
}
