% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/certify.R
\name{certify}
\alias{certify}
\alias{gt}
\alias{gte}
\alias{lt}
\alias{lte}
\alias{bounded}
\title{Ensure Conditions on a Value}
\usage{
certify(x, ..., allow_null = FALSE, id = NULL, return_id = FALSE)

gt(l)

gte(l)

lt(u)

lte(u)

bounded(l = NULL, u = NULL, incl_lower = TRUE, incl_upper = TRUE)
}
\arguments{
\item{x}{The value to be checked.}

\item{...}{Conditions to be checked; should be functions that return TRUE/FALSE.}

\item{allow_null}{Whether to allow null input.}

\item{id}{Name given to the input to aid the user in identifying the bad value.}

\item{return_id}{Whether to return the ID as an attribute. This should only be set to \code{TRUE}
when piping the result to another forge function. Defaults to \code{FALSE}.}

\item{l}{Lower bound for the inequality condition.}

\item{u}{Upper bound for the inequality condition.}

\item{incl_lower}{Whether to include the left endpoint.}

\item{incl_upper}{Whether to include the right endpoint.}
}
\description{
Checks that the input value satisfies specified conditions
}
