% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_undummy}
\alias{ec_undummy}
\title{Converts a set of dummy variables into a single categorical variable}
\usage{
ec_undummy(data_in, set_members, attribute_name, ref_level = NULL)
}
\arguments{
\item{data_in}{a data frame containing the dummy variables}

\item{set_members}{a character vector of the names of the dummy variables}

\item{attribute_name}{a character string representing the name of the new
categorical variable}

\item{ref_level}{a character string representing the name of the reference
level. If specified, a new dummy variable will be created for this level,
and it will be used as the reference category for the categorical variable.
Defaults to NULL.}
}
\value{
a data frame with the same columns as \code{data_in}, except for the
dummy variables in \code{set_members}, which are replaced with the new
categorical variable \code{attribute_name}
}
\description{
Given a set of dummy variables, this function converts them into a single
categorical variable. The categorical variable is created by determining
which variables are active (i.e. have a value of 1) for each observation and
assigning a category based on the set of active variables. If necessary, a
reference level can be specified to ensure that all possible categories are
represented. Often, all brands of a brand attribute are added as brand
intercepts, while other categorical attributes are coded with respect to a
reference level.
}
\examples{
minidata=structure(list(id = c("1", "1", "1", "1", "2", "2", "2", "2"), 
task = c(1L, 1L, 2L, 2L, 3L, 3L, 4L, 4L), 
alt = c(1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L), 
brand1 = c(1, 0, 1, 0, 1, 0, 1, 0), 
brand2 = c(0, 1, 0, 1, 0, 1, 0, 1), 
price = c(1, 2, 1, 2, 1, 2, 1, 2), 
x = c(1, 0, 0, 1, 1, 0, 1, 0)), 
class = c("tbl_df", "tbl", "data.frame"), row.names = c(NA, -8L))

minidata \%>\% ec_undummy(c('brand1','brand2'),"brand")


}
