% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fred.R
\name{fred_group}
\alias{fred_group}
\alias{fred_state}
\title{Fetch and Create a Panel of Data}
\usage{
fred_group(
  id,
  groups,
  type = c("prefix", "postfix", "infix"),
  key = NULL,
  name = NULL,
  grp_name = "group",
  realtime_start = NULL,
  realtime_end = NULL
)

fred_state(
  id,
  type = c("prefix", "postfix", "infix"),
  key = NULL,
  name = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{id}{character string containing the common series id segment}

\item{groups}{character vector denoting the variation in the series}

\item{type}{how should the group vectors be combined with the id? \code{"prefix"} places the groups before the \code{id}, \code{"postfix"} after the \code{id}, and use \code{"infix"} to place the group code between values in \code{id} *(requires \code{id} to be a length 2 character vector)*}

\item{key}{32 character lower-cased alpha-numeric character string}

\item{name}{character string describing the name of the value column. If \code{NULL}, the \code{id} will be used.}

\item{grp_name}{character string describing the name of the group column. Defaults to \code{"group"}.}

\item{realtime_start, realtime_end}{character date strings of format "YYY-MM-DD" used obtain information that was known during the specified time period. If empty, the latest update of the information is used.}
}
\value{
data.frame
}
\description{
Function that fetches data series with related codes and places the results into
a long data.frame.
}
\details{
The \code{fred_group} command is convenience function that searches for many
different series at once and places them in a panel. This is similar to the
\code{\link{fred}} command except that it can be more convenient when the series
are related to each other. For example, the statewide unemployment rates from
the Bureau of Labor Statistics have all codes with the format: \code{"<State Abbreviation><UR>"}.
If state abbreviations are located in variable \code{state.abb}, then the command
\code{fred_group("UR", state.abb, "prefix", key)} would search place all unemployment
rates into a data.frame.

\code{fred_state} is a wrapper around \code{fred_group} with the state abbreviations
used for groups and with the group column \code{"state"}.
}
\section{Functions}{
\itemize{
\item \code{fred_state}: Fetch data across each state
}}

\examples{
\dontrun{
api_key <- "abcdefghijklmnopqrstuvwxyz123456"

# Panel of Unemployment Rates Across States
unemploy <- fred_state("UR", key = api_key)
unemploy

# Panel of Constant GDP per Capita by Country
GDP <- fred_group("NYGDPPCAPKD", eFRED::countries, type="postfix",
  key=api_key, name= "gdppc", grp_name="country")
GDP
}

}
