% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{transform}
\alias{transform}
\title{transform}
\usage{
transform(x, type, par, deriv_order)
}
\arguments{
\item{x}{numeric matrix to be transformed.}

\item{type}{string, specifies the transformation function. Available are:
\enumerate{
\item  `identity`: \eqn{f(x)=x}.
\item  `exp`: \eqn{f(x)=\exp\{x\}}.
\item  `log`: \eqn{f(x)=\log\{x\}}.
\item  `glogit`: \eqn{f(x)=\log\{(-x + min)/(x - max)}, where \code{par=c(min, max)}.
\item  `glogitinv`: \eqn{f(x)=\exp\{x\} \cdot (max + min)/(1 + \exp\{x\}) }, where \code{par=c(min, max)}.
\item  `inv`: \eqn{f(x)=\frac{1}{x}}.
\item  `pnorm`: \eqn{f(x)=\Phi(x)}.
\item  `qnorm`: \eqn{f(x)=\Phi^{-1}(x)}.
\item  `mexp`: \eqn{f(x)=-\exp\{x\}}.
\item  `zeta`: \eqn{f(x)=\log\{2 \cdot \Phi(x)\}}.
\item  `constant`: \eqn{f(x)=c}.
\item  `chainrule_utility`: \eqn{f(x)=f'(x)=f''(x)=f'''(x)=f''''(x)}.
\item   onemx: \eqn{1-x}
}}

\item{par}{numeric vector, additional parameters, e.g. min and max for \code{glogit}.}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}
}
\value{
Returns an object of class \code{derivs}.
}
\description{
Transforms a matrix via the specified function.
}
\details{
Takes the numeric matrix x as an input for the function specified by \code{type} and evaluates it together with the derivatives.
}
\examples{
A<-matrix(c(1:9)/10, ncol=3)
A_mat<-list2derivs(list(A, A^0, A^2, A^3, A^4), deriv_order=4)
transform(x=transform(x = A, type="exp", par=0, deriv_order=4), type="log", deriv_order=4, par = 0)

}
