% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_mtry_prop.R
\name{mtry_prop}
\alias{mtry_prop}
\title{Proportion of Randomly Selected Predictors}
\usage{
mtry_prop(range = c(0.1, 1), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A \code{dials} object with classes "quant_param" and "param". The
\code{range} element of the object is always converted to a list with elements
"lower" and "upper".
}
\description{
The proportion of predictors that will be randomly sampled at each split when
creating tree models.
}
\section{Interpretation}{


\code{\link[=mtry_prop]{mtry_prop()}} is a variation on \code{\link[=mtry]{mtry()}} where the value is
interpreted as the \emph{proportion} of predictors that will be randomly sampled
at each split rather than the \emph{count}.

This parameter is not intended for use in accommodating engines that take in
this argument as a proportion; \code{mtry} is often a main model argument
rather than an engine-specific argument, and thus should not have an
engine-specific interface.

When wrapping modeling engines that interpret \code{mtry} in its sense as a
proportion, use the \code{\link[=mtry]{mtry()}} parameter in \code{parsnip::set_model_arg()} and
process the passed argument in an internal wrapping function as
\code{mtry / number_of_predictors}. In addition, introduce a logical argument
\code{counts} to the wrapping function, defaulting to \code{TRUE}, that indicates
whether to interpret the supplied argument as a count rather than a proportion.

For an example implementation, see \code{parsnip::xgb_train()}.
}

\examples{
mtry_prop()

}
\seealso{
mtry, mtry_long
}
