% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{gen.signal}
\alias{gen.signal}
\title{Generate simulated signals}
\usage{
gen.signal(l, h, jump, b1, rep = 1, shift = 0)
}
\arguments{
\item{l}{length of data, if data is periodic then the length in each period}

\item{h}{numerical vector of true change point locations}

\item{jump}{numerical vector of jump size at change point locations}

\item{b1}{numerical vector of piecewise slopes}

\item{rep}{number of periods if data is periodic, default is 1}

\item{shift}{numerical vector of vertical shifts for each period, default is 0}
}
\value{
a vector of simulated signal
}
\description{
Generate simulated signals
}
\examples{
l = 1200
h = seq(150,by=150,length.out=6)
jump = rep(0,7)
beta1 = c(2,-1,2.5,-3,-0.2,2.5)/50
beta1 = c(beta1,-sum(beta1*(c(h[1],diff(h))))/(l-tail(h,1)))
signal = gen.signal(l,h,jump,beta1)
}
