% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vendor.R
\name{cpp_vendor}
\alias{cpp_vendor}
\title{Vendor the cpp11 dependency}
\usage{
cpp_vendor(path = ".")
}
\arguments{
\item{path}{The path to the package root directory}
}
\value{
The file path to the vendored code (invisibly).
}
\description{
Vendoring is the act of making your own copy of the 3rd party packages your
project is using. It is often used in the go language community.
}
\details{
This function vendors cpp11 into your package by copying the cpp11
headers into the \code{inst/include} folder of your package and adding
'cpp11 version: XYZ' to the top of the files, where XYZ is the version of
cpp11 currently installed on your machine.

If you choose to vendor the headers you should \emph{remove} \code{LinkingTo: cpp11} from your DESCRIPTION.

\strong{Note}: vendoring places the responsibility of updating the code on
\strong{you}. Bugfixes and new features in cpp11 will not be available for your
code until you run \code{cpp_vendor()} again.
}
\examples{
# create a new directory
dir <- tempfile()
dir.create(dir)

# vendor the cpp11 headers into the directory
cpp_vendor(dir)

list.files(file.path(dir, "inst", "include", "cpp11"))

# cleanup
unlink(dir, recursive = TRUE)
}
