% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cladoRcpp.R
\name{rcpp_calc_splitlikes_using_COOweights_columnar}
\alias{rcpp_calc_splitlikes_using_COOweights_columnar}
\title{Calculate the split likelihoods using \code{COO_weights_columnar}}
\usage{
rcpp_calc_splitlikes_using_COOweights_columnar(Rcpp_leftprobs,
  Rcpp_rightprobs, COO_weights_columnar, Rsp_rowsums, printmat = TRUE)
}
\arguments{
\item{Rcpp_leftprobs}{Probabilities of the states at the base of the left descendant branch}

\item{Rcpp_rightprobs}{Probabilities of the states at the base of the right descendant branch}

\item{COO_weights_columnar}{Transition probability matrix in COO-like format as 4 columns: 
ancestral index, left index, right index, conditional probability given ancestral states.
(assuming likelihood of descendants is 1). Indexes are 0-based.
Keep in mind that cladogenesis matrices exclude the null state
(a range of 0 areas), so if your states list starts with the 
null range (as is typical/default in DEC-style models)
then to get the R 1-based state indices requires e.g. 
COO_weights_columnar[[1]] + 2.}

\item{Rsp_rowsums}{A vector of size (numstates)  giving the sum of the relative probabilites of 
each combination of descendant states, assuming the probabilities of the left- and right-states are 
all equal (set to 1). This is thus the sum of the weights, and dividing by this normalization vector 
means that the each row of the speciation probability matrix will sum to 1.  Default assumes the 
weights sum to 1 but this is not usually the case. Rsp_rowsums need only be calculated once per 
tree+model combination, stored, and then re-used for each node in the tree, yielding significant 
time savings.}

\item{printmat}{Should the probability matrix output be printed to screen? (useful for debugging, but 
can be dramatically slow in R.app for some reason for even moderate numbers of states; perhaps 
overrunning the line length...)}
}
\value{
\code{splitlikes} Vector of the probabilities of each allowed split
}
\description{
Calculates the split likelihoods using \code{COO_weights_columnar}, i.e. the weights as produced by
\code{\link{rcpp_calc_anclikes_sp_COOweights_faster}}.
}
\examples{
# For the basic logic of a probablistic cladogenesis model, see
?rcpp_calc_anclikes_sp

# For examples of running the functions, see the comparison of all functions at:
# ?cladoRcpp

}
\seealso{
\code{\link{rcpp_calc_anclikes_sp}}
#bibliography /Dropbox/_njm/__packages/cladoRcpp_setup/cladoRcpp_refs.bib
  @cite Matzke_2013
  @cite Matzke_2014
}
\author{
Nicholas Matzke \email{matzke@berkeley.edu}
}
