% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cjbart.R
\name{cjbart}
\alias{cjbart}
\title{Generate Conjoint Model Using BART}
\usage{
cjbart(
  data,
  Y,
  type = NULL,
  id = NULL,
  round = NULL,
  use_round = TRUE,
  cores = 1,
  ...
)
}
\arguments{
\item{data}{A data.frame, containing all attributes, controls, the outcome and id variables to analyze.}

\item{Y}{Character string -- the outcome variable}

\item{type}{Type of conjoint experiment -- either "choice" (for forced-choice outcomes) or "rating" (for interval ratings). If NULL (default), the function will attempt to automatically detect the outcome type.}

\item{id}{Character string -- variable identifying individual respondents (optional)}

\item{round}{Character string -- variable identifying rounds of the conjoint experiment}

\item{use_round}{Boolean -- whether to include the round indicator column when training the BART model (default = \code{TRUE})}

\item{cores}{Integer -- number of CPU cores used in model training}

\item{...}{Other arguments passed to \code{\link[BART:mc.pbart]{BART::mc.pbart()}} if on a Unix-based system}
}
\value{
A trained \code{\link[BART:pbart]{BART::pbart()}} model that can be passed to \code{\link[=IMCE]{IMCE()}}
}
\description{
A wrapper for the \code{\link[BART:pbart]{BART::pbart()}} function used for estimating heterogeneity in conjoint models
}
\details{
Please note, Windows users cannot use the parallelized \code{\link[BART:mc.pbart]{BART::mc.pbart()}} function, and so setting an internal seed will not be used.
}
\examples{
subjects <- 5
rounds <- 2
profiles <- 2
obs <- subjects*rounds*profiles

fake_data <- data.frame(A = sample(c("a1","a2"), obs, replace = TRUE),
                        B = sample(c("b1","b2"), obs, replace = TRUE),
                        id1 = rep(1:subjects, each=rounds),
                        stringsAsFactors = TRUE)

fake_data$Y <- sample(c(0,1), obs, replace = TRUE)

cj_model <- cjbart(data = fake_data,
                   Y = "Y",
                   id = "id1")
}
\seealso{
\code{\link[BART:pbart]{BART::pbart()}}
}
