## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SparseArray")

## ---- message=FALSE-----------------------------------------------------------
library(SparseArray)

## -----------------------------------------------------------------------------
m <- matrix(0L, nrow=6, ncol=4)
m[c(1:2, 8, 10, 15:17, 24)] <- (1:8)*10L
svt1 <- as(m, "SVT_SparseArray")
svt1

a <- array(0L, 5:3)
a[c(1:2, 8, 10, 15:17, 20, 24, 40, 56:60)] <- (1:15)*10L
svt2 <- as(a, "SVT_SparseArray")
svt2

## -----------------------------------------------------------------------------
svt1 <- SVT_SparseArray(m)
svt2 <- SVT_SparseArray(a)

## -----------------------------------------------------------------------------
svt1 <- as(m, "SparseArray")
svt2 <- as(a, "SparseArray")

## -----------------------------------------------------------------------------
svt1 <- SparseArray(m)
svt2 <- SparseArray(a)

## -----------------------------------------------------------------------------
as.array(svt1)  # same as as.matrix(svt1)

as.array(svt2)

## -----------------------------------------------------------------------------
dim(svt2)

length(svt2)

dimnames(svt2) <- list(NULL, letters[1:4], LETTERS[1:3])
svt2

## -----------------------------------------------------------------------------
type(svt1)

type(svt1) <- "double"
svt1

is_sparse(svt1)

nzcount(svt1)

sparsity(svt1)

## -----------------------------------------------------------------------------
svt2[5:3, , "C"]

## -----------------------------------------------------------------------------
type(svt2)
svt2[5, 1, 3] <- NaN
type(svt2)

## -----------------------------------------------------------------------------
anyNA(svt2)

range(svt2, na.rm=TRUE)

mean(svt2, na.rm=TRUE)

## -----------------------------------------------------------------------------
randomSparseArray(c(5, 6, 2), density=0.5)

poissonSparseArray(c(5, 6, 2), density=0.5)

## -----------------------------------------------------------------------------
t(svt1)

## -----------------------------------------------------------------------------
svt3 <- poissonSparseMatrix(6, 2, density=0.5)

cbind(svt1, svt3)

## -----------------------------------------------------------------------------
m4 <- matrix(0L, nrow=5, ncol=6, dimnames=list(letters[1:5], LETTERS[1:6]))
m4[c(2, 6, 12:17, 22:30)] <- 101:117
svt4 <- SparseArray(m4)

svt4 %*% svt3

## -----------------------------------------------------------------------------
crossprod(svt3)

## -----------------------------------------------------------------------------
rowVars(svt4, useNames=TRUE)

## -----------------------------------------------------------------------------
rowsum(svt4, group=c(1:3, 2:1))

## -----------------------------------------------------------------------------
csv_file <- tempfile()
writeSparseCSV(m4, csv_file)

## -----------------------------------------------------------------------------
readSparseCSV(csv_file)

## -----------------------------------------------------------------------------
sessionInfo()

